/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.components.confetti;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.ViewGroup;
import com.brightwell.readyremit.sdk.R;
import com.brightwell.readyremit.sdk.internal.components.confetti.ConfettiManager;
import com.brightwell.readyremit.sdk.internal.components.confetti.ConfettiSource;
import com.brightwell.readyremit.sdk.internal.components.confetti.ConfettoGenerator;
import com.brightwell.readyremit.sdk.internal.components.confetti.Utils;
import com.brightwell.readyremit.sdk.internal.components.confetti.confetto.BitmapConfetto;
import com.brightwell.readyremit.sdk.internal.components.confetti.confetto.Confetto;
import java.util.List;
import java.util.Random;

public class CommonConfetti {
    private static int defaultConfettiSize;
    private static int defaultVelocitySlow;
    private static int defaultVelocityNormal;
    private static int defaultVelocityFast;
    private static int explosionRadius;
    private ConfettiManager confettiManager;

    private CommonConfetti(ViewGroup container) {
        CommonConfetti.ensureStaticResources(container);
    }

    public static CommonConfetti rainingConfetti(ViewGroup container, int[] colors) {
        CommonConfetti commonConfetti = new CommonConfetti(container);
        ConfettiSource confettiSource = new ConfettiSource(0, -defaultConfettiSize, container.getWidth(), -defaultConfettiSize);
        commonConfetti.configureRainingConfetti(container, confettiSource, colors);
        return commonConfetti;
    }

    public static CommonConfetti rainingConfetti(ViewGroup container, ConfettiSource confettiSource, int[] colors) {
        CommonConfetti commonConfetti = new CommonConfetti(container);
        commonConfetti.configureRainingConfetti(container, confettiSource, colors);
        return commonConfetti;
    }

    public static CommonConfetti explosion(ViewGroup container, int x, int y, int[] colors) {
        CommonConfetti commonConfetti = new CommonConfetti(container);
        commonConfetti.configureExplosion(container, x, y, colors);
        return commonConfetti;
    }

    public ConfettiManager getConfettiManager() {
        return this.confettiManager;
    }

    public ConfettiManager oneShot() {
        return this.confettiManager.setNumInitialCount(100).setEmissionDuration(0L).animate();
    }

    public ConfettiManager stream(long durationInMillis) {
        return this.confettiManager.setNumInitialCount(0).setEmissionDuration(durationInMillis).setEmissionRate(50.0f).animate();
    }

    public ConfettiManager infinite() {
        return this.confettiManager.setNumInitialCount(0).setEmissionDuration(Long.MAX_VALUE).setEmissionRate(50.0f).animate();
    }

    private ConfettoGenerator getDefaultGenerator(int[] colors) {
        final List<Bitmap> bitmaps = Utils.generateConfettiBitmaps(colors, defaultConfettiSize);
        final int numBitmaps = bitmaps.size();
        return new ConfettoGenerator(){

            @Override
            public Confetto generateConfetto(Random random) {
                return new BitmapConfetto((Bitmap)bitmaps.get(random.nextInt(numBitmaps)));
            }
        };
    }

    private void configureRainingConfetti(ViewGroup container, ConfettiSource confettiSource, int[] colors) {
        Context context = container.getContext();
        ConfettoGenerator generator = this.getDefaultGenerator(colors);
        this.confettiManager = new ConfettiManager(context, generator, confettiSource, container).setVelocityX(0.0f, defaultVelocitySlow).setVelocityY(defaultVelocityNormal, defaultVelocitySlow).setInitialRotation(180, 180).setRotationalAcceleration(360.0f, 180.0f).setTargetRotationalVelocity(360.0f);
    }

    private void configureExplosion(ViewGroup container, int x, int y, int[] colors) {
        Context context = container.getContext();
        ConfettoGenerator generator = this.getDefaultGenerator(colors);
        ConfettiSource confettiSource = new ConfettiSource(x, y);
        this.confettiManager = new ConfettiManager(context, generator, confettiSource, container).setTTL(1000L).setBound(new Rect(x - explosionRadius, y - explosionRadius, x + explosionRadius, y + explosionRadius)).setVelocityX(0.0f, defaultVelocityFast).setVelocityY(0.0f, defaultVelocityFast).enableFadeOut(Utils.getDefaultAlphaInterpolator()).setInitialRotation(180, 180).setRotationalAcceleration(360.0f, 180.0f).setTargetRotationalVelocity(360.0f);
    }

    private static void ensureStaticResources(ViewGroup container) {
        if (defaultConfettiSize == 0) {
            Resources res = container.getResources();
            defaultConfettiSize = res.getDimensionPixelSize(R.dimen.default_confetti_size);
            defaultVelocitySlow = res.getDimensionPixelOffset(R.dimen.default_velocity_slow);
            defaultVelocityNormal = res.getDimensionPixelOffset(R.dimen.default_velocity_normal);
            defaultVelocityFast = res.getDimensionPixelOffset(R.dimen.default_velocity_fast);
            explosionRadius = res.getDimensionPixelOffset(R.dimen.default_explosion_radius);
        }
    }
}

