/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.components.confetti.confetto;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.animation.Interpolator;

public abstract class Confetto {
    private static final int MAX_ALPHA = 255;
    private static final long RESET_ANIMATION_INITIAL_DELAY = -1L;
    private final Matrix matrix = new Matrix();
    private final Paint workPaint = new Paint(1);
    private final float[] workPairs = new float[2];
    private Rect bound;
    private long initialDelay;
    private float initialX;
    private float initialY;
    private float initialVelocityX;
    private float initialVelocityY;
    private float accelerationX;
    private float accelerationY;
    private Float targetVelocityX;
    private Float targetVelocityY;
    private Long millisToReachTargetVelocityX;
    private Long millisToReachTargetVelocityY;
    private float initialRotation;
    private float initialRotationalVelocity;
    private float rotationalAcceleration;
    private Float targetRotationalVelocity;
    private Long millisToReachTargetRotationalVelocity;
    private long ttl;
    private Interpolator fadeOutInterpolator;
    private float millisToReachBound;
    private float percentageAnimated;
    private float currentX;
    private float currentY;
    private float currentRotation;
    protected float currentVelocityX;
    protected float currentVelocityY;
    protected float currentRotationalVelocity;
    private int alpha;
    private boolean startedAnimation;
    private boolean terminated;
    private boolean touchOverride;
    private VelocityTracker velocityTracker;
    private float overrideX;
    private float overrideY;
    private float overrideVelocityX;
    private float overrideVelocityY;
    private float overrideDeltaX;
    private float overrideDeltaY;

    public void prepare(Rect bound) {
        this.bound = bound;
        this.millisToReachTargetVelocityX = Confetto.computeMillisToReachTarget(this.targetVelocityX, this.initialVelocityX, this.accelerationX);
        this.millisToReachTargetVelocityY = Confetto.computeMillisToReachTarget(this.targetVelocityY, this.initialVelocityY, this.accelerationY);
        this.millisToReachTargetRotationalVelocity = Confetto.computeMillisToReachTarget(this.targetRotationalVelocity, this.initialRotationalVelocity, this.rotationalAcceleration);
        this.millisToReachBound = this.ttl >= 0L ? (float)this.ttl : 9.223372E18f;
        long timeToReachXBound = Confetto.computeBound(this.initialX, this.initialVelocityX, this.accelerationX, this.millisToReachTargetVelocityX, this.targetVelocityX, bound.left - this.getWidth(), bound.right);
        this.millisToReachBound = Math.min((float)timeToReachXBound, this.millisToReachBound);
        long timeToReachYBound = Confetto.computeBound(this.initialY, this.initialVelocityY, this.accelerationY, this.millisToReachTargetVelocityY, this.targetVelocityY, bound.top - this.getHeight(), bound.bottom);
        this.millisToReachBound = Math.min((float)timeToReachYBound, this.millisToReachBound);
        this.configurePaint(this.workPaint);
    }

    private boolean doesLocationIntercept(float x, float y) {
        return this.currentX <= x && x <= this.currentX + (float)this.getWidth() && this.currentY <= y && y <= this.currentY + (float)this.getHeight();
    }

    public boolean onTouchDown(MotionEvent event) {
        float y;
        float x = event.getX();
        if (this.doesLocationIntercept(x, y = event.getY())) {
            this.touchOverride = true;
            this.overrideX = x;
            this.overrideY = y;
            this.overrideDeltaX = this.currentX - x;
            this.overrideDeltaY = this.currentY - y;
            this.velocityTracker = VelocityTracker.obtain();
            this.velocityTracker.addMovement(event);
            return true;
        }
        return false;
    }

    public void onTouchMove(MotionEvent event) {
        this.overrideX = event.getX();
        this.overrideY = event.getY();
        this.velocityTracker.addMovement(event);
        this.velocityTracker.computeCurrentVelocity(1);
        this.overrideVelocityX = this.velocityTracker.getXVelocity();
        this.overrideVelocityY = this.velocityTracker.getYVelocity();
    }

    public void onTouchUp(MotionEvent event) {
        this.velocityTracker.addMovement(event);
        this.velocityTracker.computeCurrentVelocity(1);
        this.initialDelay = -1L;
        this.initialX = event.getX() + this.overrideDeltaX;
        this.initialY = event.getY() + this.overrideDeltaY;
        this.initialVelocityX = this.velocityTracker.getXVelocity();
        this.initialVelocityY = this.velocityTracker.getYVelocity();
        this.initialRotation = this.currentRotation;
        this.velocityTracker.recycle();
        this.velocityTracker = null;
        this.prepare(this.bound);
        this.touchOverride = false;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    protected static Long computeMillisToReachTarget(Float targetVelocity, float initialVelocity, float acceleration) {
        if (targetVelocity != null) {
            if (acceleration != 0.0f) {
                long time = (long)((targetVelocity.floatValue() - initialVelocity) / acceleration);
                return time > 0L ? time : 0L;
            }
            if (targetVelocity.floatValue() < initialVelocity) {
                return 0L;
            }
            return null;
        }
        return null;
    }

    protected static long computeBound(float initialPos, float velocity, float acceleration, Long targetTime, Float targetVelocity, int minBound, int maxBound) {
        int bound;
        if (acceleration != 0.0f) {
            int bound2;
            int n = bound2 = acceleration > 0.0f ? maxBound : minBound;
            if (targetTime == null || targetTime < 0L) {
                double tmp = Math.sqrt(2.0f * acceleration * (float)bound2 - 2.0f * acceleration * initialPos + velocity * velocity);
                double firstTime = (-tmp - (double)velocity) / (double)acceleration;
                if (firstTime > 0.0) {
                    return (long)firstTime;
                }
                double secondTime = (tmp - (double)velocity) / (double)acceleration;
                if (secondTime > 0.0) {
                    return (long)secondTime;
                }
                return Long.MAX_VALUE;
            }
            double time = ((double)((float)bound2 - initialPos - velocity * (float)targetTime.longValue()) - 0.5 * (double)acceleration * (double)targetTime.longValue() * (double)targetTime.longValue() + (double)(targetVelocity.floatValue() * (float)targetTime.longValue())) / (double)targetVelocity.floatValue();
            return time > 0.0 ? (long)time : Long.MAX_VALUE;
        }
        float actualVelocity = targetTime == null ? velocity : targetVelocity.floatValue();
        int n = bound = actualVelocity > 0.0f ? maxBound : minBound;
        if (actualVelocity != 0.0f) {
            double time = ((float)bound - initialPos) / actualVelocity;
            return time > 0.0 ? (long)time : Long.MAX_VALUE;
        }
        return Long.MAX_VALUE;
    }

    public void reset() {
        this.initialDelay = 0L;
        this.initialY = 0.0f;
        this.initialX = 0.0f;
        this.initialVelocityY = 0.0f;
        this.initialVelocityX = 0.0f;
        this.accelerationY = 0.0f;
        this.accelerationX = 0.0f;
        this.targetVelocityY = null;
        this.targetVelocityX = null;
        this.millisToReachTargetVelocityY = null;
        this.millisToReachTargetVelocityX = null;
        this.initialRotation = 0.0f;
        this.initialRotationalVelocity = 0.0f;
        this.rotationalAcceleration = 0.0f;
        this.targetRotationalVelocity = null;
        this.millisToReachTargetRotationalVelocity = null;
        this.ttl = 0L;
        this.millisToReachBound = 0.0f;
        this.percentageAnimated = 0.0f;
        this.fadeOutInterpolator = null;
        this.currentY = 0.0f;
        this.currentX = 0.0f;
        this.currentVelocityY = 0.0f;
        this.currentVelocityX = 0.0f;
        this.currentRotation = 0.0f;
        this.alpha = 255;
        this.startedAnimation = false;
        this.terminated = false;
    }

    protected void configurePaint(Paint paint) {
        paint.setAlpha(this.alpha);
    }

    public boolean applyUpdate(long passedTime) {
        long animatedTime;
        if (this.initialDelay == -1L) {
            this.initialDelay = passedTime;
        }
        boolean bl = this.startedAnimation = (animatedTime = passedTime - this.initialDelay) >= 0L;
        if (this.startedAnimation && !this.terminated) {
            this.computeDistance(this.workPairs, animatedTime, this.initialX, this.initialVelocityX, this.accelerationX, this.millisToReachTargetVelocityX, this.targetVelocityX);
            this.currentX = this.workPairs[0];
            this.currentVelocityX = this.workPairs[1];
            this.computeDistance(this.workPairs, animatedTime, this.initialY, this.initialVelocityY, this.accelerationY, this.millisToReachTargetVelocityY, this.targetVelocityY);
            this.currentY = this.workPairs[0];
            this.currentVelocityY = this.workPairs[1];
            this.computeDistance(this.workPairs, animatedTime, this.initialRotation, this.initialRotationalVelocity, this.rotationalAcceleration, this.millisToReachTargetRotationalVelocity, this.targetRotationalVelocity);
            this.currentRotation = this.workPairs[0];
            this.currentRotationalVelocity = this.workPairs[1];
            if (this.fadeOutInterpolator != null) {
                float interpolatedTime = this.fadeOutInterpolator.getInterpolation((float)animatedTime / this.millisToReachBound);
                this.alpha = (int)(interpolatedTime * 255.0f);
            } else {
                this.alpha = 255;
            }
            this.terminated = !this.touchOverride && (float)animatedTime >= this.millisToReachBound;
            this.percentageAnimated = Math.min(1.0f, (float)animatedTime / this.millisToReachBound);
        }
        return !this.terminated;
    }

    private void computeDistance(float[] pair, long t, float xi, float vi, float ai, Long targetTime, Float vTarget) {
        float x;
        float vX;
        pair[1] = vX = ai * (float)t + vi;
        pair[0] = targetTime == null || t < targetTime ? (x = xi + vi * (float)t + 0.5f * ai * (float)t * (float)t) : (x = xi + vi * (float)targetTime.longValue() + 0.5f * ai * (float)targetTime.longValue() * (float)targetTime.longValue() + (float)(t - targetTime) * vTarget.floatValue());
    }

    public void draw(Canvas canvas) {
        if (this.touchOverride) {
            this.currentVelocityX = this.overrideVelocityX;
            this.currentVelocityY = this.overrideVelocityY;
            this.draw(canvas, this.overrideX + this.overrideDeltaX, this.overrideY + this.overrideDeltaY, this.currentRotation, this.percentageAnimated);
        } else if (this.startedAnimation && !this.terminated) {
            this.draw(canvas, this.currentX, this.currentY, this.currentRotation, this.percentageAnimated);
        }
    }

    private void draw(Canvas canvas, float x, float y, float rotation, float percentageAnimated) {
        canvas.save();
        canvas.clipRect(this.bound);
        this.matrix.reset();
        this.workPaint.setAlpha(this.alpha);
        this.drawInternal(canvas, this.matrix, this.workPaint, x, y, rotation, percentageAnimated);
        canvas.restore();
    }

    protected abstract void drawInternal(Canvas var1, Matrix var2, Paint var3, float var4, float var5, float var6, float var7);

    public void setInitialDelay(long val) {
        this.initialDelay = val;
    }

    public void setInitialX(float val) {
        this.initialX = val;
    }

    public void setInitialY(float val) {
        this.initialY = val;
    }

    public void setInitialVelocityX(float val) {
        this.initialVelocityX = val;
    }

    public void setInitialVelocityY(float val) {
        this.initialVelocityY = val;
    }

    public void setAccelerationX(float val) {
        this.accelerationX = val;
    }

    public void setAccelerationY(float val) {
        this.accelerationY = val;
    }

    public void setTargetVelocityX(Float val) {
        this.targetVelocityX = val;
    }

    public void setTargetVelocityY(Float val) {
        this.targetVelocityY = val;
    }

    public void setInitialRotation(float val) {
        this.initialRotation = val;
    }

    public void setInitialRotationalVelocity(float val) {
        this.initialRotationalVelocity = val;
    }

    public void setRotationalAcceleration(float val) {
        this.rotationalAcceleration = val;
    }

    public void setTargetRotationalVelocity(Float val) {
        this.targetRotationalVelocity = val;
    }

    public void setTTL(long val) {
        this.ttl = val;
    }

    public void setFadeOut(Interpolator fadeOutInterpolator) {
        this.fadeOutInterpolator = fadeOutInterpolator;
    }
}

