/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.input;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.internal.api.data.Country;
import com.brightwell.readyremit.sdk.internal.input.CountryField;
import com.brightwell.readyremit.sdk.internal.input.PickerInputField;
import com.brightwell.readyremit.sdk.internal.input.PickerItem;
import com.brightwell.readyremit.sdk.internal.resources.CountryCodes;
import com.brightwell.readyremit.sdk.internal.resources.CountryIso;
import com.brightwell.readyremit.sdk.internal.resources.FlagResourcesKt;
import com.brightwell.readyremit.sdk.utils.StringExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\"\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010 \u001a\u00020\u001fJ\"\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010 \u001a\u00020\u001fR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R0\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00110\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010RJ\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u001a0\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010 \u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006)"}, d2={"Lcom/brightwell/readyremit/sdk/internal/input/CountryField;", "Lcom/brightwell/readyremit/sdk/internal/input/PickerInputField;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "countries", "", "Lcom/brightwell/readyremit/sdk/internal/input/PickerItem;", "value", "", "countryCodes", "getCountryCodes", "()Ljava/util/List;", "setCountryCodes", "(Ljava/util/List;)V", "Lcom/brightwell/readyremit/sdk/internal/api/data/Country;", "countryList", "getCountryList", "setCountryList", "onCountrySelected", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "code", "", "getOnCountrySelected", "()Lkotlin/jvm/functions/Function2;", "setOnCountrySelected", "(Lkotlin/jvm/functions/Function2;)V", "", "showFlags", "getShowFlags", "()Z", "setShowFlags", "(Z)V", "fillList", "mapCountryToPickerItems", "list", "mapToPickerItems", "sdk_internalRelease"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCountryField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountryField.kt\ncom/brightwell/readyremit/sdk/internal/input/CountryField\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1549#2:82\n1620#2,3:83\n1045#2:86\n1549#2:87\n1620#2,3:88\n1549#2:91\n1620#2,3:92\n1045#2:95\n*S KotlinDebug\n*F\n+ 1 CountryField.kt\ncom/brightwell/readyremit/sdk/internal/input/CountryField\n*L\n51#1:82\n51#1:83,3\n58#1:86\n63#1:87\n63#1:88,3\n64#1:91\n64#1:92,3\n71#1:95\n*E\n"})
public final class CountryField
extends PickerInputField {
    @NotNull
    private List<Country> countryList;
    @NotNull
    private List<String> countryCodes;
    private boolean showFlags;
    @NotNull
    private List<PickerItem> countries;
    @NotNull
    private Function2<? super String, ? super String, Unit> onCountrySelected;
    public static final int $stable = 8;

    public CountryField(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.countryList = CollectionsKt.emptyList();
        this.countryCodes = CollectionsKt.emptyList();
        this.showFlags = true;
        this.countries = this.fillList();
        this.onCountrySelected = onCountrySelected.1.INSTANCE;
        this.setItemsList(this.countries);
        this.setOnItemSelected((Function1<? super PickerItem, Unit>)((Function1)new Function1<PickerItem, Unit>(){

            public final void invoke(@NotNull PickerItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.getOnCountrySelected().invoke((Object)it.getValue(), (Object)it.getDisplayText());
            }
        }));
        this.validateListSize();
    }

    @NotNull
    public final List<Country> getCountryList() {
        return this.countryList;
    }

    public final void setCountryList(@NotNull List<Country> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.countryList = value;
        this.setItemsList(this.mapCountryToPickerItems(value, this.showFlags));
        this.validateListSize();
    }

    @NotNull
    public final List<String> getCountryCodes() {
        return this.countryCodes;
    }

    public final void setCountryCodes(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.countryCodes = value;
        this.setItemsList(this.mapToPickerItems(value, this.showFlags));
        this.validateListSize();
    }

    public final boolean getShowFlags() {
        return this.showFlags;
    }

    public final void setShowFlags(boolean value) {
        this.showFlags = value;
        this.setItemsList(this.fillList());
        this.validateListSize();
    }

    @NotNull
    public final Function2<String, String, Unit> getOnCountrySelected() {
        return this.onCountrySelected;
    }

    public final void setOnCountrySelected(@NotNull Function2<? super String, ? super String, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.onCountrySelected = function2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PickerItem> mapCountryToPickerItems(@NotNull List<Country> list, boolean showFlags) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Drawable drawable2;
            void it;
            Country country = (Country)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getIso3Code();
            if (showFlags) {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                drawable2 = FlagResourcesKt.getFlagDrawableForCountryCode(context, it.getIso3Code());
            } else {
                drawable2 = null;
            }
            collection.add(new PickerItem(string2, drawable2, it.getName(), null, 8, null));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PickerItem it = (PickerItem)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getDisplayText());
                it = (PickerItem)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplayText())));
            }
        });
    }

    @NotNull
    public final List<PickerItem> mapToPickerItems(@NotNull List<String> list, boolean showFlags) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = StringExtKt.onlyLetters(it).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            collection.add(string3);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Drawable drawable2;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (showFlags) {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                drawable2 = FlagResourcesKt.getFlagDrawableForCountryCode(context, it);
            } else {
                drawable2 = null;
            }
            collection.add(new PickerItem(it, drawable2, CountryCodes.INSTANCE.getNameForIsoCode(it), null, 8, null));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PickerItem it = (PickerItem)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getDisplayText());
                it = (PickerItem)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplayText())));
            }
        });
    }

    private final List<PickerItem> fillList() {
        Collection collection = this.countryCodes;
        return collection == null || collection.isEmpty() ? this.mapToPickerItems(CountryIso.INSTANCE.getALL(), this.showFlags) : this.mapToPickerItems(this.countryCodes, this.showFlags);
    }
}

