/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.input;

import android.content.Context;
import android.util.AttributeSet;
import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.R;
import com.brightwell.readyremit.sdk.internal.api.data.InputField;
import com.brightwell.readyremit.sdk.internal.input.EditablePickerInputField;
import com.brightwell.readyremit.sdk.internal.input.PickerItem;
import com.brightwell.readyremit.sdk.internal.input.Validatable;
import com.brightwell.readyremit.sdk.internal.input.widget.InputEditText;
import com.brightwell.readyremit.sdk.internal.resources.CountryCodes;
import com.brightwell.readyremit.sdk.internal.resources.CountryIso;
import com.brightwell.readyremit.sdk.internal.resources.FlagResourcesKt;
import com.brightwell.readyremit.sdk.utils.StringExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000fR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR0\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lcom/brightwell/readyremit/sdk/internal/input/PhoneCountryAndNumberField;", "Lcom/brightwell/readyremit/sdk/internal/input/EditablePickerInputField;", "Lkotlinx/coroutines/CoroutineScope;", "Lcom/brightwell/readyremit/sdk/internal/input/Validatable;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "value", "", "", "countryCodes", "getCountryCodes", "()Ljava/util/List;", "setCountryCodes", "(Ljava/util/List;)V", "phoneFieldModel", "Lcom/brightwell/readyremit/sdk/internal/api/data/InputField$Phone;", "getPhoneFieldModel", "()Lcom/brightwell/readyremit/sdk/internal/api/data/InputField$Phone;", "setPhoneFieldModel", "(Lcom/brightwell/readyremit/sdk/internal/api/data/InputField$Phone;)V", "fillList", "", "isInputValid", "", "mapToPickerItems", "Lcom/brightwell/readyremit/sdk/internal/input/PickerItem;", "list", "setExplicitNumber", "sdk_internalRelease"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPhoneCountryAndNumberField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhoneCountryAndNumberField.kt\ncom/brightwell/readyremit/sdk/internal/input/PhoneCountryAndNumberField\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1549#2:111\n1620#2,3:112\n1360#2:115\n1446#2,2:116\n1549#2:118\n1620#2,3:119\n1448#2,3:122\n1045#2:125\n*S KotlinDebug\n*F\n+ 1 PhoneCountryAndNumberField.kt\ncom/brightwell/readyremit/sdk/internal/input/PhoneCountryAndNumberField\n*L\n48#1:111\n48#1:112,3\n49#1:115\n49#1:116,2\n52#1:118\n52#1:119,3\n49#1:122,3\n61#1:125\n*E\n"})
public final class PhoneCountryAndNumberField
extends EditablePickerInputField
implements CoroutineScope,
Validatable {
    @NotNull
    private List<String> countryCodes;
    @Nullable
    private InputField.Phone phoneFieldModel;
    public static final int $stable = 8;

    public PhoneCountryAndNumberField(@NotNull Context context, @Nullable AttributeSet attrs) {
        InputEditText inputEditText;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.countryCodes = CollectionsKt.emptyList();
        InputEditText $this$_init__u24lambda_u240 = inputEditText = this.getPickerEditTextField();
        boolean bl = false;
        $this$_init__u24lambda_u240.setInputType(3);
        $this$_init__u24lambda_u240.setImeOptions(6);
        this.fillList();
    }

    @NotNull
    public final List<String> getCountryCodes() {
        return this.countryCodes;
    }

    public final void setCountryCodes(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.countryCodes = value;
        this.setItemsList(this.mapToPickerItems(value));
        this.validateListSize();
    }

    @Nullable
    public final InputField.Phone getPhoneFieldModel() {
        return this.phoneFieldModel;
    }

    public final void setPhoneFieldModel(@Nullable InputField.Phone phone) {
        this.phoneFieldModel = phone;
    }

    public final void setExplicitNumber(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value, null){
            int label;
            final /* synthetic */ PhoneCountryAndNumberField this$0;
            final /* synthetic */ String $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.getPickerEditTextField().setText(this.$value);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PickerItem> mapToPickerItems(@NotNull List<String> list) {
        void $this$flatMapTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string3 = StringExtKt.onlyLetters(it).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            collection.add(string3);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            it = (String)element$iv$iv;
            boolean bl = false;
            String countryName = CountryCodes.INSTANCE.getNameForIsoCode(it);
            String string4 = CountryCodes.INSTANCE.getIso2ToPhone().get(CountryCodes.INSTANCE.getIso3ToIso2().get(it));
            if (string4 == null) {
                string4 = "";
            }
            String phoneCodes = string4;
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)phoneCodes, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void code;
                String string5 = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                collection.add(new PickerItem(it, FlagResourcesKt.getFlagDrawableForCountryCode(context, it), (String)code, countryName));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PickerItem it = (PickerItem)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getValue());
                it = (PickerItem)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getValue())));
            }
        });
    }

    @Override
    public void fillList() {
        this.setItemsList(this.mapToPickerItems(CountryIso.INSTANCE.getALL()));
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)Dispatchers.getMain();
    }

    @Override
    public boolean isInputValid() {
        boolean bl;
        InputField.Phone phone = this.phoneFieldModel;
        if (phone == null) {
            return true;
        }
        InputField.Phone model = phone;
        if (model.getVisibility() == InputField.Visibility.SHOW_AND_OPTIONAL) {
            return true;
        }
        String enteredPhone = ((Object)StringsKt.trim((CharSequence)String.valueOf(this.getPickerEditTextField().getText()))).toString();
        String selectedCountry = this.getSelectedItem().getValue();
        Regex pattern = new Regex(model.getRegex());
        if (StringsKt.isBlank((CharSequence)enteredPhone) & model.isRequired()) {
            Object[] objectArray = new Object[]{model.getName()};
            String string2 = this.getContext().getString(R.string.rrm_error_empty_dynamic_field, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            this.showErrorText(string2);
            bl = false;
        } else if (((CharSequence)enteredPhone).length() > 0 & enteredPhone.length() < model.getMinLength()) {
            Object[] objectArray = new Object[]{model.getName(), model.getMinLength()};
            String string3 = this.getContext().getString(R.string.rrm_error_minlength_number, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            this.showErrorText(string3);
            bl = false;
        } else if (((CharSequence)enteredPhone).length() > 0 & ((CharSequence)model.getRegex()).length() > 0 & !pattern.containsMatchIn((CharSequence)enteredPhone)) {
            Object[] objectArray = new Object[]{model.getName()};
            String string4 = this.getContext().getString(R.string.rrm_error_invalid_dynamic_field, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            this.showErrorText(string4);
            bl = false;
        } else if (((CharSequence)selectedCountry).length() == 0) {
            Object[] objectArray = new Object[]{model.getName()};
            String string5 = this.getContext().getString(R.string.rrm_error_empty_dynamic_field, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
            this.showErrorText(string5);
            bl = false;
        } else {
            this.clearValidationText();
            bl = true;
        }
        return bl;
    }
}

