/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.input;

import android.content.Context;
import android.content.DialogInterface;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.R;
import com.brightwell.readyremit.sdk.internal.api.data.InputField;
import com.brightwell.readyremit.sdk.internal.input.InputField;
import com.brightwell.readyremit.sdk.internal.input.PickerDialog;
import com.brightwell.readyremit.sdk.internal.input.PickerInputField;
import com.brightwell.readyremit.sdk.internal.input.PickerItem;
import com.brightwell.readyremit.sdk.internal.input.Validatable;
import com.brightwell.readyremit.sdk.internal.input.widget.InputTextView;
import com.brightwell.readyremit.sdk.internal.view.ViewExtKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010:\u001a\u00020\u0011H\u0016J\b\u0010;\u001a\u00020\"H\u0014J\u000e\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u00020>J\u0010\u0010?\u001a\u00020\"2\u0006\u0010!\u001a\u00020\u0017H\u0002J\u0012\u0010@\u001a\u00020\"2\b\b\u0002\u0010A\u001a\u00020\u0011H\u0002J\b\u0010B\u001a\u00020\"H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR5\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\"0\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u00020+X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R$\u00101\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0017@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\"\u00107\u001a\u0004\u0018\u0001062\b\u0010\u0015\u001a\u0004\u0018\u000106@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b8\u00109\u00a8\u0006C"}, d2={"Lcom/brightwell/readyremit/sdk/internal/input/PickerInputField;", "Lcom/brightwell/readyremit/sdk/internal/input/InputField;", "Lcom/brightwell/readyremit/sdk/internal/input/Validatable;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "dropdownModel", "Lcom/brightwell/readyremit/sdk/internal/api/data/InputField$Dropdown;", "getDropdownModel", "()Lcom/brightwell/readyremit/sdk/internal/api/data/InputField$Dropdown;", "setDropdownModel", "(Lcom/brightwell/readyremit/sdk/internal/api/data/InputField$Dropdown;)V", "extraLayout", "Landroid/view/View;", "hasSelectedItemText", "", "getHasSelectedItemText", "()Z", "isPickerShowing", "value", "", "Lcom/brightwell/readyremit/sdk/internal/input/PickerItem;", "itemsList", "getItemsList", "()Ljava/util/List;", "setItemsList", "(Ljava/util/List;)V", "onItemSelected", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "item", "", "getOnItemSelected", "()Lkotlin/jvm/functions/Function1;", "setOnItemSelected", "(Lkotlin/jvm/functions/Function1;)V", "pickerImage", "Landroid/widget/ImageView;", "pickerImageContainer", "pickerImageInput", "Lcom/brightwell/readyremit/sdk/internal/input/widget/InputTextView;", "pickerInput", "getPickerInput", "()Lcom/brightwell/readyremit/sdk/internal/input/widget/InputTextView;", "setPickerInput", "(Lcom/brightwell/readyremit/sdk/internal/input/widget/InputTextView;)V", "selectedItem", "getSelectedItem", "()Lcom/brightwell/readyremit/sdk/internal/input/PickerItem;", "setSelectedItem", "(Lcom/brightwell/readyremit/sdk/internal/input/PickerItem;)V", "", "selectedItemText", "setSelectedItemText", "(Ljava/lang/CharSequence;)V", "isInputValid", "onEffectiveLabelValueChanged", "setDefaultItem", "searchedText", "", "setImageToPickerInput", "updateLabelDisplay", "animated", "validateListSize", "sdk_internalRelease"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPickerInputField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PickerInputField.kt\ncom/brightwell/readyremit/sdk/internal/input/PickerInputField\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
public class PickerInputField
extends InputField
implements Validatable {
    @NotNull
    private InputTextView pickerInput;
    @NotNull
    private InputTextView pickerImageInput;
    @NotNull
    private final ImageView pickerImage;
    @NotNull
    private final View pickerImageContainer;
    @NotNull
    private final View extraLayout;
    private boolean isPickerShowing;
    @NotNull
    private List<PickerItem> itemsList;
    @NotNull
    private PickerItem selectedItem;
    @NotNull
    private Function1<? super PickerItem, Unit> onItemSelected;
    @Nullable
    private InputField.Dropdown dropdownModel;
    @Nullable
    private CharSequence selectedItemText;
    public static final int $stable = 8;

    public PickerInputField(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, R.layout.ready_remit_input_field_picker, attrs);
        this.pickerInput = (InputTextView)ViewExtKt.findRequiredViewById((View)this, R.id.rrm_input_picker);
        this.pickerImageInput = (InputTextView)ViewExtKt.findRequiredViewById((View)this, R.id.rrm_picker_image_background);
        this.pickerImage = (ImageView)ViewExtKt.findRequiredViewById((View)this, R.id.rrm_picker_image);
        this.pickerImageContainer = ViewExtKt.findRequiredViewById((View)this, R.id.rrm_picker_image_container);
        this.extraLayout = ViewExtKt.findRequiredViewById((View)this, R.id.extra_layout);
        this.itemsList = CollectionsKt.emptyList();
        this.selectedItem = new PickerItem("", null, null, null, 14, null);
        this.onItemSelected = onItemSelected.1.INSTANCE;
        this.pickerInput.setFocusable(true);
        this.pickerInput.setFocusableInTouchMode(true);
        this.pickerInput.setOnFocusChangeListener((arg_0, arg_1) -> PickerInputField._init_$lambda$3(this, context, arg_0, arg_1));
        this.pickerInput.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        this.registerValidationStateHolder(this.pickerInput);
        this.registerEnabledMirror((View)this.pickerInput);
        PickerInputField.updateLabelDisplay$default(this, false, 1, null);
        this.validateListSize();
    }

    @NotNull
    protected final InputTextView getPickerInput() {
        return this.pickerInput;
    }

    protected final void setPickerInput(@NotNull InputTextView inputTextView) {
        Intrinsics.checkNotNullParameter((Object)inputTextView, (String)"<set-?>");
        this.pickerInput = inputTextView;
    }

    private final boolean getHasSelectedItemText() {
        CharSequence charSequence = this.selectedItemText;
        return !(charSequence == null || charSequence.length() == 0);
    }

    @NotNull
    public final List<PickerItem> getItemsList() {
        return this.itemsList;
    }

    public final void setItemsList(@NotNull List<PickerItem> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.itemsList = value;
        this.validateListSize();
    }

    @NotNull
    public final PickerItem getSelectedItem() {
        return this.selectedItem;
    }

    protected final void setSelectedItem(@NotNull PickerItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (Intrinsics.areEqual((Object)this.selectedItem.getValue(), (Object)item.getValue())) {
            return;
        }
        this.selectedItem = item;
        this.setSelectedItemText(this.selectedItem.getDisplayText());
        this.setImageToPickerInput(this.selectedItem);
        this.onItemSelected.invoke((Object)this.selectedItem);
        this.clearValidationText();
    }

    public final void setDefaultItem(@NotNull String searchedText) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)searchedText, (String)"searchedText");
            Iterable iterable = this.itemsList;
            for (Object t : iterable) {
                PickerItem it = (PickerItem)t;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)it.getValue(), (Object)searchedText) || Intrinsics.areEqual((Object)it.getDisplayText(), (Object)searchedText) || Intrinsics.areEqual((Object)it.getSecondarydisplayText(), (Object)searchedText);
                if (!bl2) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        PickerItem pickerItem = v1;
        if (pickerItem != null) {
            PickerItem it = pickerItem;
            boolean bl = false;
            this.setSelectedItem(it);
        }
        if (Intrinsics.areEqual((Object)searchedText, (Object)"")) {
            this.setSelectedItem(new PickerItem("", null, null, null, 14, null));
        }
    }

    @NotNull
    public final Function1<PickerItem, Unit> getOnItemSelected() {
        return this.onItemSelected;
    }

    public final void setOnItemSelected(@NotNull Function1<? super PickerItem, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onItemSelected = function1;
    }

    @Nullable
    public final InputField.Dropdown getDropdownModel() {
        return this.dropdownModel;
    }

    public final void setDropdownModel(@Nullable InputField.Dropdown dropdown) {
        this.dropdownModel = dropdown;
    }

    private final void setSelectedItemText(CharSequence value) {
        block0: {
            CharSequence charSequence;
            CharSequence it = charSequence = value;
            boolean bl = false;
            CharSequence charSequence2 = !Intrinsics.areEqual((Object)it, (Object)this.selectedItemText) ? charSequence : null;
            if (charSequence2 == null) break block0;
            it = charSequence2;
            boolean bl2 = false;
            this.selectedItemText = value;
            this.pickerInput.setText(this.selectedItemText);
            this.updateLabelDisplay(false);
        }
    }

    @Override
    protected void onEffectiveLabelValueChanged() {
        super.onEffectiveLabelValueChanged();
        this.pickerInput.setHint(this.getEffectiveLabelText());
    }

    private final void updateLabelDisplay(boolean animated) {
        if (this.getHasSelectedItemText()) {
            this.showLabel(animated);
        } else {
            this.hideLabel(animated);
        }
    }

    static /* synthetic */ void updateLabelDisplay$default(PickerInputField pickerInputField, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateLabelDisplay");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        pickerInputField.updateLabelDisplay(bl);
    }

    public void validateListSize() {
        this.pickerInput.setEnabled(this.itemsList.size() > 1);
        this.pickerImageInput.setEnabled(this.itemsList.size() > 1);
        if (this.itemsList.isEmpty()) {
            this.setSelectedItem(new PickerItem("", null, null, null, 14, null));
        }
        if (this.itemsList.size() == 1) {
            this.setSelectedItem(this.itemsList.get(0));
        }
        if (this.itemsList.size() > 1) {
            this.pickerInput.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.ready_remit_ic_chevron_down_24, 0);
        } else {
            this.pickerInput.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        }
    }

    private final void setImageToPickerInput(PickerItem item) {
        if (item.getImage() != null) {
            this.pickerImage.setImageDrawable(item.getImage());
            ViewExtKt.show(this.pickerImageContainer);
        } else {
            ViewExtKt.collapse(this.pickerImageContainer);
        }
    }

    @Override
    public boolean isInputValid() {
        boolean bl;
        InputField.Dropdown dropdown = this.dropdownModel;
        if (dropdown == null) {
            return true;
        }
        InputField.Dropdown model = dropdown;
        if (model.getVisibility() == InputField.Visibility.SHOW_AND_OPTIONAL) {
            return true;
        }
        String value = this.selectedItem.getValue();
        Regex pattern = new Regex(model.getRegex());
        if (StringsKt.isBlank((CharSequence)value)) {
            Object[] objectArray = new Object[]{model.getName()};
            String string2 = this.getContext().getString(R.string.rrm_error_empty_dynamic_field, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            this.showErrorText(string2);
            bl = false;
        } else if (((CharSequence)value).length() > 0 & ((CharSequence)model.getRegex()).length() > 0 & !pattern.containsMatchIn((CharSequence)value)) {
            Object[] objectArray = new Object[]{model.getName()};
            String string3 = this.getContext().getString(R.string.rrm_error_invalid_dynamic_field, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            this.showErrorText(string3);
            bl = false;
        } else {
            this.clearValidationText();
            bl = true;
        }
        return bl;
    }

    private static final void lambda$3$lambda$2(PickerInputField this$0, View $view, DialogInterface it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isPickerShowing = false;
        this$0.extraLayout.requestFocus();
        $view.clearFocus();
    }

    private static final void _init_$lambda$3(PickerInputField this$0, Context $context, View view, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        if (this$0.isPickerShowing) {
            return;
        }
        if (hasFocus) {
            this$0.isPickerShowing = true;
            PickerDialog picker2 = new PickerDialog($context, this$0.itemsList, (Function1<? super PickerItem, Unit>)((Function1)new Function1<PickerItem, Unit>(this$0){
                final /* synthetic */ PickerInputField this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull PickerItem it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.setSelectedItem(it);
                }
            }), this$0.getLabelText());
            picker2.setOnDismissListener(arg_0 -> PickerInputField.lambda$3$lambda$2(this$0, view, arg_0));
            if (!picker2.isShowing()) {
                picker2.show();
            }
            this$0.extraLayout.requestFocus();
            view.clearFocus();
        }
    }
}

