/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.input;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.R;
import com.brightwell.readyremit.sdk.internal.api.data.InputField;
import com.brightwell.readyremit.sdk.internal.input.InputField;
import com.brightwell.readyremit.sdk.internal.input.Validatable;
import com.brightwell.readyremit.sdk.internal.input.widget.InputEditText;
import com.brightwell.readyremit.sdk.internal.view.ViewExtKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0012\u0010\u001b\u001a\u00020\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u0017H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/brightwell/readyremit/sdk/internal/input/TextInputField;", "Lcom/brightwell/readyremit/sdk/internal/input/InputField;", "Lcom/brightwell/readyremit/sdk/internal/input/Validatable;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "clearButton", "Landroid/widget/ImageView;", "getClearButton", "()Landroid/widget/ImageView;", "inputEditText", "Lcom/brightwell/readyremit/sdk/internal/input/widget/InputEditText;", "getInputEditText", "()Lcom/brightwell/readyremit/sdk/internal/input/widget/InputEditText;", "model", "Lcom/brightwell/readyremit/sdk/internal/api/data/InputField$Text;", "getModel", "()Lcom/brightwell/readyremit/sdk/internal/api/data/InputField$Text;", "setModel", "(Lcom/brightwell/readyremit/sdk/internal/api/data/InputField$Text;)V", "isInputValid", "", "onEffectiveLabelValueChanged", "", "updateClearButtonVisibility", "updateLabelVisibility", "animated", "sdk_internalRelease"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTextInputField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextInputField.kt\ncom/brightwell/readyremit/sdk/internal/input/TextInputField\n+ 2 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,133:1\n375#2,2:134\n387#2,2:136\n*S KotlinDebug\n*F\n+ 1 TextInputField.kt\ncom/brightwell/readyremit/sdk/internal/input/TextInputField\n*L\n89#1:134,2\n89#1:136,2\n*E\n"})
public final class TextInputField
extends InputField
implements Validatable {
    @NotNull
    private final InputEditText inputEditText;
    @NotNull
    private final ImageView clearButton;
    @Nullable
    private InputField.Text model;
    public static final int $stable = 8;

    public TextInputField(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, R.layout.ready_remit_input_field_text, attrs);
        this.inputEditText = (InputEditText)ViewExtKt.findRequiredViewById((View)this, R.id.rrm_input_edit_text);
        this.clearButton = (ImageView)ViewExtKt.findRequiredViewById((View)this, R.id.rrm_button_clear);
        this.registerValidationStateHolder(this.inputEditText);
        this.registerEnabledMirror((View)this.inputEditText);
        this.inputEditText.setOnFocusChangeListener((arg_0, arg_1) -> TextInputField._init_$lambda$0(this, arg_0, arg_1));
        TextWatcher watcher2 = new TextWatcher(this){
            final /* synthetic */ TextInputField this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeTextChanged(@NotNull CharSequence s, int start, int count, int after) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            }

            public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                InputField.Text text = this.this$0.getModel();
                boolean bl = text != null ? text.shouldBeAllCaps() : false;
                if (bl) {
                    this.this$0.getInputEditText().removeTextChangedListener(this);
                    InputEditText inputEditText = this.this$0.getInputEditText();
                    String string2 = ((Object)s).toString().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    inputEditText.setText(string2);
                    Editable editable = this.this$0.getInputEditText().getText();
                    this.this$0.getInputEditText().setSelection(editable != null ? editable.length() : 0);
                    this.this$0.getInputEditText().addTextChangedListener(this);
                }
            }

            public void afterTextChanged(@NotNull Editable s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                TextInputField.access$updateLabelVisibility(this.this$0, false);
                TextInputField.access$updateClearButtonVisibility(this.this$0);
                this.this$0.clearValidationText();
            }
        };
        this.inputEditText.addTextChangedListener(watcher2);
        this.clearButton.setOnClickListener(arg_0 -> TextInputField._init_$lambda$1(this, arg_0));
        TextInputField.updateLabelVisibility$default(this, false, 1, null);
        this.updateClearButtonVisibility();
    }

    @NotNull
    public final InputEditText getInputEditText() {
        return this.inputEditText;
    }

    @NotNull
    public final ImageView getClearButton() {
        return this.clearButton;
    }

    @Nullable
    public final InputField.Text getModel() {
        return this.model;
    }

    public final void setModel(@Nullable InputField.Text text) {
        this.model = text;
    }

    @Override
    protected void onEffectiveLabelValueChanged() {
        super.onEffectiveLabelValueChanged();
        this.inputEditText.setHint(this.getEffectiveLabelText());
        this.inputEditText.setId(View.generateViewId());
        this.inputEditText.setSaveEnabled(true);
    }

    private final void updateLabelVisibility(boolean animated) {
        CharSequence charSequence = (CharSequence)this.inputEditText.getText();
        if (charSequence == null || charSequence.length() == 0) {
            this.hideLabel(animated);
        } else {
            this.showLabel(animated);
        }
    }

    static /* synthetic */ void updateLabelVisibility$default(TextInputField textInputField, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        textInputField.updateLabelVisibility(bl);
    }

    /*
     * Unable to fully structure code
     */
    private final void updateClearButtonVisibility() {
        if (!this.inputEditText.isFocused()) ** GOTO lbl-1000
        v0 = this.inputEditText.getText();
        v1 = v0 != null ? ((CharSequence)v0).length() > 0 : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        shouldDisplayClear = v2;
        ViewExtKt.showOrCollapse((View)this.clearButton, shouldDisplayClear);
        var3_2 = shouldDisplayClear;
        if (var3_2) {
            $this$marginStart$iv = (View)this.clearButton;
            $i$f$getMarginStart = false;
            v3 = this.clearButton.getWidth() + ((lp$iv = $this$marginStart$iv.getLayoutParams()) instanceof ViewGroup.MarginLayoutParams != false ? ((ViewGroup.MarginLayoutParams)lp$iv).getMarginStart() : 0);
            $this$marginEnd$iv = (View)this.clearButton;
            $i$f$getMarginEnd = false;
            lp$iv = $this$marginEnd$iv.getLayoutParams();
            v4 = v3 + (lp$iv instanceof ViewGroup.MarginLayoutParams != false ? ((ViewGroup.MarginLayoutParams)lp$iv).getMarginEnd() : 0);
        } else if (!var3_2) {
            v4 = this.inputEditText.getPaddingStart();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        inputDodgeClearEndPadding = v4;
        this.inputEditText.setPaddingRelative(this.inputEditText.getPaddingStart(), this.inputEditText.getPaddingTop(), inputDodgeClearEndPadding, this.inputEditText.getPaddingBottom());
    }

    @Override
    public boolean isInputValid() {
        boolean bl;
        InputField.Text text = this.model;
        if (text == null) {
            return true;
        }
        InputField.Text model = text;
        if (model.getVisibility() == InputField.Visibility.SHOW_AND_OPTIONAL) {
            return true;
        }
        String inputValue = ((Object)StringsKt.trim((CharSequence)String.valueOf(this.inputEditText.getText()))).toString();
        Regex pattern = new Regex(model.getRegex());
        if (((CharSequence)inputValue).length() == 0 & model.isRequired()) {
            Object[] objectArray = new Object[]{model.getName()};
            String string2 = this.getContext().getString(R.string.rrm_error_empty_dynamic_field, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            this.showErrorText(string2);
            bl = false;
        } else if (((CharSequence)inputValue).length() > 0 & inputValue.length() < model.getMinLength()) {
            Object[] objectArray = new Object[]{model.getName(), model.getMinLength()};
            String string3 = this.getContext().getString(R.string.rrm_error_minlength_number, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            this.showErrorText(string3);
            bl = false;
        } else if (((CharSequence)inputValue).length() > 0 & ((CharSequence)model.getRegex()).length() > 0 & !pattern.containsMatchIn((CharSequence)inputValue)) {
            Object[] objectArray = new Object[]{model.getName()};
            String string4 = this.getContext().getString(R.string.rrm_error_invalid_dynamic_field, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            this.showErrorText(string4);
            bl = false;
        } else {
            this.clearValidationText();
            bl = true;
        }
        return bl;
    }

    private static final void _init_$lambda$0(TextInputField this$0, View view, boolean isFocused) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setShouldMirrorFocused(isFocused);
        this$0.updateClearButtonVisibility();
    }

    private static final void _init_$lambda$1(TextInputField this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.inputEditText.setText("");
    }

    public static final /* synthetic */ void access$updateLabelVisibility(TextInputField $this, boolean animated) {
        $this.updateLabelVisibility(animated);
    }

    public static final /* synthetic */ void access$updateClearButtonVisibility(TextInputField $this) {
        $this.updateClearButtonVisibility();
    }
}

