/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u001bH\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/brightwell/readyremit/sdk/utils/BorderedDrawable;", "Landroid/graphics/drawable/DrawableWrapper;", "context", "Landroid/content/Context;", "drawable", "Landroid/graphics/drawable/Drawable;", "(Landroid/content/Context;Landroid/graphics/drawable/Drawable;)V", "borderThickness", "", "(Landroid/graphics/drawable/Drawable;F)V", "borderPaint", "Landroid/graphics/Paint;", "borderPath", "Landroid/graphics/Path;", "clipPath", "overlayGradientPaint", "cornerRadiusFor", "bounds", "Landroid/graphics/RectF;", "createBorderPath", "createOutlineClipPath", "createOverlayGradientPaint", "draw", "", "canvas", "Landroid/graphics/Canvas;", "onBoundsChange", "Landroid/graphics/Rect;", "sdk_internalRelease"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBorderedDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BorderedDrawable.kt\ncom/brightwell/readyremit/sdk/utils/BorderedDrawable\n+ 2 Rect.kt\nandroidx/core/graphics/RectKt\n*L\n1#1,112:1\n337#2:113\n337#2:114\n*S KotlinDebug\n*F\n+ 1 BorderedDrawable.kt\ncom/brightwell/readyremit/sdk/utils/BorderedDrawable\n*L\n29#1:113\n37#1:114\n*E\n"})
public final class BorderedDrawable
extends DrawableWrapper {
    @NotNull
    private Path clipPath;
    @NotNull
    private Path borderPath;
    @NotNull
    private Paint overlayGradientPaint;
    private final float borderThickness;
    @NotNull
    private final Paint borderPaint;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public BorderedDrawable(@Nullable Drawable drawable2, float borderThickness) {
        super(drawable2);
        void $this$borderPaint_u24lambda_u240;
        Paint paint;
        this.borderThickness = RangesKt.coerceAtLeast((float)borderThickness, (float)1.0f);
        Paint paint2 = paint = new Paint();
        BorderedDrawable borderedDrawable = this;
        boolean bl = false;
        $this$borderPaint_u24lambda_u240.setColor(Color.argb((float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f));
        $this$borderPaint_u24lambda_u240.setStyle(Paint.Style.STROKE);
        $this$borderPaint_u24lambda_u240.setStrokeWidth(this.borderThickness);
        $this$borderPaint_u24lambda_u240.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
        borderedDrawable.borderPaint = paint;
        Rect rect = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getBounds(...)");
        Rect $this$toRectF$iv = rect;
        boolean $i$f$toRectF = false;
        RectF boundsF = new RectF($this$toRectF$iv);
        this.clipPath = this.createOutlineClipPath(boundsF);
        this.borderPath = this.createBorderPath(boundsF);
        this.overlayGradientPaint = this.createOverlayGradientPaint(boundsF);
    }

    public BorderedDrawable(@NotNull Context context, @Nullable Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(drawable2, context.getResources().getDisplayMetrics().density);
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        super.onBoundsChange(bounds);
        Rect $this$toRectF$iv = bounds;
        boolean $i$f$toRectF = false;
        RectF boundsF = new RectF($this$toRectF$iv);
        this.clipPath = this.createOutlineClipPath(boundsF);
        this.borderPath = this.createBorderPath(boundsF);
        this.overlayGradientPaint = this.createOverlayGradientPaint(boundsF);
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.clipPath(this.clipPath);
        super.draw(canvas);
        if (Build.VERSION.SDK_INT >= 28) {
            canvas.drawPath(this.clipPath, this.overlayGradientPaint);
        }
        canvas.drawPath(this.borderPath, this.borderPaint);
    }

    private final Path createOutlineClipPath(RectF bounds) {
        Path path;
        float cornerRadius = this.cornerRadiusFor(bounds);
        Path $this$createOutlineClipPath_u24lambda_u241 = path = new Path();
        boolean bl = false;
        $this$createOutlineClipPath_u24lambda_u241.addRoundRect(bounds, cornerRadius, cornerRadius, Path.Direction.CW);
        return path;
    }

    private final Path createBorderPath(RectF bounds) {
        Path path;
        RectF rectF;
        float borderInset = this.borderThickness / 2.0f;
        RectF $this$createBorderPath_u24lambda_u242 = rectF = new RectF();
        boolean bl = false;
        $this$createBorderPath_u24lambda_u242.left = bounds.left + borderInset;
        $this$createBorderPath_u24lambda_u242.top = bounds.top + borderInset;
        $this$createBorderPath_u24lambda_u242.right = bounds.right - borderInset;
        $this$createBorderPath_u24lambda_u242.bottom = bounds.bottom - borderInset;
        RectF borderBounds = rectF;
        float cornerRadius = this.cornerRadiusFor(borderBounds);
        Path $this$createBorderPath_u24lambda_u243 = path = new Path();
        boolean bl2 = false;
        $this$createBorderPath_u24lambda_u243.addRoundRect(borderBounds, cornerRadius, cornerRadius, Path.Direction.CW);
        return path;
    }

    private final float cornerRadiusFor(RectF bounds) {
        return bounds.height() / 10.0f;
    }

    private final Paint createOverlayGradientPaint(RectF bounds) {
        Paint paint;
        float lineX = bounds.width() / 2.0f;
        float startY = 0.5f;
        float endY = bounds.height() - 0.5f;
        Paint $this$createOverlayGradientPaint_u24lambda_u244 = paint = new Paint();
        boolean bl = false;
        $this$createOverlayGradientPaint_u24lambda_u244.setStyle(Paint.Style.FILL);
        Object[] objectArray = new int[]{Color.argb((int)178, (int)255, (int)255, (int)255), Color.argb((int)76, (int)0, (int)0, (int)0)};
        int[] nArray = objectArray;
        objectArray = new float[2];
        objectArray[0] = (int)0.0f;
        objectArray[1] = (int)1.0f;
        $this$createOverlayGradientPaint_u24lambda_u244.setShader((Shader)new LinearGradient(lineX, startY, lineX, endY, nArray, (float[])objectArray, Shader.TileMode.CLAMP));
        $this$createOverlayGradientPaint_u24lambda_u244.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.OVERLAY));
        return paint;
    }
}

