/*
 * Decompiled with CFR 0.152.
 */
package io.github.briqt.spark4j;

import io.github.briqt.spark4j.constant.SparkApiVersion;
import io.github.briqt.spark4j.exception.SparkException;
import io.github.briqt.spark4j.listener.SparkBaseListener;
import io.github.briqt.spark4j.listener.SparkSyncChatListener;
import io.github.briqt.spark4j.model.SparkSyncChatResponse;
import io.github.briqt.spark4j.model.request.SparkRequest;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocketListener;

public class SparkClient {
    public String appid;
    public String apiKey;
    public String apiSecret;
    public OkHttpClient client = new OkHttpClient.Builder().build();

    public void chatStream(SparkRequest sparkRequest, SparkBaseListener listener) {
        sparkRequest.getHeader().setAppId(this.appid);
        listener.setSparkRequest(sparkRequest);
        SparkApiVersion apiVersion = sparkRequest.getApiVersion();
        String apiUrl = apiVersion.getUrl();
        String authWsUrl = null;
        try {
            authWsUrl = this.getAuthUrl(apiUrl).replace("http://", "ws://").replace("https://", "wss://");
        }
        catch (Exception e) {
            throw new SparkException(500, "\u6784\u5efa\u9274\u6743url\u5931\u8d25", e);
        }
        Request request = new Request.Builder().url(authWsUrl).build();
        this.client.newWebSocket(request, (WebSocketListener)listener);
    }

    public SparkSyncChatResponse chatSync(SparkRequest sparkRequest) {
        SparkSyncChatResponse chatResponse = new SparkSyncChatResponse();
        SparkSyncChatListener syncChatListener = new SparkSyncChatListener(chatResponse);
        this.chatStream(sparkRequest, syncChatListener);
        while (!chatResponse.isOk()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Throwable exception = chatResponse.getException();
        if (exception != null) {
            if (!(exception instanceof SparkException)) {
                exception = new SparkException(500, exception.getMessage());
            }
            throw (SparkException)exception;
        }
        return chatResponse;
    }

    public String getAuthUrl(String apiUrl) throws Exception {
        URL url = new URL(apiUrl);
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = format.format(new Date());
        String preStr = "host: " + url.getHost() + "\ndate: " + date + "\nGET " + url.getPath() + " HTTP/1.1";
        Mac mac = Mac.getInstance("hmacsha256");
        SecretKeySpec spec = new SecretKeySpec(this.apiSecret.getBytes(StandardCharsets.UTF_8), "hmacsha256");
        mac.init(spec);
        byte[] hexDigits = mac.doFinal(preStr.getBytes(StandardCharsets.UTF_8));
        String sha = Base64.getEncoder().encodeToString(hexDigits);
        String authorization = String.format("api_key=\"%s\", algorithm=\"%s\", headers=\"%s\", signature=\"%s\"", this.apiKey, "hmac-sha256", "host date request-line", sha);
        HttpUrl httpUrl = Objects.requireNonNull(HttpUrl.parse((String)("https://" + url.getHost() + url.getPath()))).newBuilder().addQueryParameter("authorization", Base64.getEncoder().encodeToString(authorization.getBytes(StandardCharsets.UTF_8))).addQueryParameter("date", date).addQueryParameter("host", url.getHost()).build();
        return httpUrl.toString();
    }
}

