/*
 * Decompiled with CFR 0.152.
 */
package io.github.briqt.spark4j.listener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.briqt.spark4j.constant.SparkApiVersion;
import io.github.briqt.spark4j.listener.SparkBaseListener;
import io.github.briqt.spark4j.model.SparkMessage;
import io.github.briqt.spark4j.model.request.SparkRequest;
import io.github.briqt.spark4j.model.response.SparkResponse;
import io.github.briqt.spark4j.model.response.SparkResponseFunctionCall;
import io.github.briqt.spark4j.model.response.SparkResponseUsage;
import io.github.briqt.spark4j.model.response.SparkTextUsage;
import java.util.List;
import java.util.Map;
import okhttp3.Response;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkConsoleListener
extends SparkBaseListener {
    private static final Logger logger = LoggerFactory.getLogger(SparkConsoleListener.class);
    private final StringBuilder stringBuilder = new StringBuilder();
    public ObjectMapper objectMapper = new ObjectMapper();

    public SparkConsoleListener() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public void onMessage(String content, SparkResponseUsage usage, Integer status, SparkRequest sparkRequest, SparkResponse sparkResponse, WebSocket webSocket) {
        this.stringBuilder.append(content);
        if (0 == status) {
            List<SparkMessage> messages = sparkRequest.getPayload().getMessage().getText();
            try {
                SparkApiVersion apiVersion = sparkRequest.getApiVersion();
                System.out.println("\u8bf7\u6c42\u5730\u5740\uff1a" + apiVersion.getUrl() + "  \u7248\u672c\uff1a" + apiVersion.getVersion());
                System.out.println("\n\u63d0\u95ee\uff1a" + this.objectMapper.writeValueAsString(messages));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            System.out.println("\n\u6536\u5230\u56de\u7b54\uff1a\n");
        }
        try {
            System.out.println("--content\uff1a" + content + " --\u5b8c\u6574\u54cd\u5e94\uff1a" + this.objectMapper.writeValueAsString((Object)sparkResponse));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        if (2 == status) {
            System.out.println("\n\u5b8c\u6574\u56de\u7b54\uff1a" + this.stringBuilder);
            SparkTextUsage textUsage = usage.getText();
            System.out.println("\n\u56de\u7b54\u7ed3\u675f\uff1b\u63d0\u95eetokens\uff1a" + textUsage.getPromptTokens() + "\uff0c\u56de\u7b54tokens\uff1a" + textUsage.getCompletionTokens() + "\uff0c\u603b\u6d88\u8017tokens\uff1a" + textUsage.getTotalTokens());
        }
    }

    @Override
    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, Response response) {
        logger.error("\u8baf\u98de\u661f\u706bapi\u53d1\u751f\u5f02\u5e38\uff1a", t);
    }

    @Override
    public void onFunctionCall(SparkResponseFunctionCall functionCall, SparkResponseUsage usage, Integer status, SparkRequest sparkRequest, SparkResponse sparkResponse, WebSocket webSocket) {
        String functionCallName = functionCall.getName();
        Map<String, Object> arguments = functionCall.getMapArguments();
        try {
            System.out.println("\n\u6536\u5230functionCall\uff1a\u65b9\u6cd5\u540d\u79f0\uff1a" + functionCallName + "\uff0c\u53c2\u6570\uff1a" + this.objectMapper.writeValueAsString(arguments));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

