/*
 * Decompiled with CFR 0.152.
 */
package io.github.briqt.spark4j.listener;

import io.github.briqt.spark4j.listener.SparkBaseListener;
import io.github.briqt.spark4j.model.SparkSyncChatResponse;
import io.github.briqt.spark4j.model.request.SparkRequest;
import io.github.briqt.spark4j.model.response.SparkResponse;
import io.github.briqt.spark4j.model.response.SparkResponseFunctionCall;
import io.github.briqt.spark4j.model.response.SparkResponseUsage;
import okhttp3.Response;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSyncChatListener
extends SparkBaseListener {
    private static final Logger logger = LoggerFactory.getLogger(SparkSyncChatListener.class);
    private final StringBuilder stringBuilder = new StringBuilder();
    private final SparkSyncChatResponse sparkSyncChatResponse;

    public SparkSyncChatListener(SparkSyncChatResponse sparkSyncChatResponse) {
        this.sparkSyncChatResponse = sparkSyncChatResponse;
    }

    @Override
    public void onMessage(String content, SparkResponseUsage usage, Integer status, SparkRequest sparkRequest, SparkResponse sparkResponse, WebSocket webSocket) {
        this.stringBuilder.append(content);
        if (2 == status) {
            this.sparkSyncChatResponse.setContent(this.stringBuilder.toString());
            this.sparkSyncChatResponse.setTextUsage(usage.getText());
            this.sparkSyncChatResponse.setOk(true);
        }
    }

    @Override
    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, Response response) {
        logger.error("\u8baf\u98de\u661f\u706bapi\u53d1\u751f\u5f02\u5e38", t);
        this.sparkSyncChatResponse.setOk(true);
        this.sparkSyncChatResponse.setException(t);
    }

    @Override
    public void onFunctionCall(SparkResponseFunctionCall functionCall, SparkResponseUsage usage, Integer status, SparkRequest sparkRequest, SparkResponse sparkResponse, WebSocket webSocket) {
        if (2 == status) {
            this.sparkSyncChatResponse.setContent(this.stringBuilder.toString());
            this.sparkSyncChatResponse.setTextUsage(usage.getText());
            this.sparkSyncChatResponse.setFunctionCall(functionCall);
            this.sparkSyncChatResponse.setOk(true);
        }
    }
}

