/*
 * Decompiled with CFR 0.152.
 */
package io.github.briqt.spark4j.model.request.function;

import io.github.briqt.spark4j.model.request.function.SparkRequestFunctionMessage;
import io.github.briqt.spark4j.model.request.function.SparkRequestFunctionParameters;
import io.github.briqt.spark4j.model.request.function.SparkRequestFunctionProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SparkFunctionBuilder {
    private final SparkRequestFunctionMessage sparkRequestFunctionMessage = new SparkRequestFunctionMessage();

    public SparkFunctionBuilder() {
        this.sparkRequestFunctionMessage.setParameters(new SparkRequestFunctionParameters("object", new LinkedHashMap<String, SparkRequestFunctionProperty>(), new ArrayList<String>()));
    }

    public static SparkFunctionBuilder functionName(String name) {
        return new SparkFunctionBuilder().name(name);
    }

    public SparkFunctionBuilder name(String name) {
        this.sparkRequestFunctionMessage.setName(name);
        return this;
    }

    public SparkFunctionBuilder description(String description) {
        this.sparkRequestFunctionMessage.setDescription(description);
        return this;
    }

    public SparkFunctionBuilder parameterType(String type) {
        this.sparkRequestFunctionMessage.getParameters().setType(type);
        return this;
    }

    public SparkFunctionBuilder addParameterProperty(String name, String type, String description) {
        this.sparkRequestFunctionMessage.getParameters().getProperties().put(name, new SparkRequestFunctionProperty(type, description));
        return this;
    }

    public SparkFunctionBuilder addParameterRequired(String ... name) {
        for (String s : name) {
            this.sparkRequestFunctionMessage.getParameters().getRequired().add(s);
        }
        return this;
    }

    public SparkFunctionBuilder parameters(String type, Map<String, SparkRequestFunctionProperty> properties, List<String> required) {
        this.sparkRequestFunctionMessage.setParameters(new SparkRequestFunctionParameters(type, properties, required));
        return this;
    }

    public SparkRequestFunctionMessage build() {
        return this.sparkRequestFunctionMessage;
    }
}

