/*
 * Decompiled with CFR 0.152.
 */
package io.github.briqt.spark4j.listener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.briqt.spark4j.exception.SparkException;
import io.github.briqt.spark4j.model.SparkMessage;
import io.github.briqt.spark4j.model.request.SparkRequest;
import io.github.briqt.spark4j.model.response.SparkResponse;
import io.github.briqt.spark4j.model.response.SparkResponseChoices;
import io.github.briqt.spark4j.model.response.SparkResponseFunctionCall;
import io.github.briqt.spark4j.model.response.SparkResponseHeader;
import io.github.briqt.spark4j.model.response.SparkResponseUsage;
import java.util.List;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkBaseListener
extends WebSocketListener {
    private static final Logger logger = LoggerFactory.getLogger(SparkBaseListener.class);
    private SparkRequest sparkRequest;
    public ObjectMapper objectMapper = new ObjectMapper();

    public SparkBaseListener() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void onMessage(String content, SparkResponseUsage usage, Integer status, SparkRequest sparkRequest, SparkResponse sparkResponse, WebSocket webSocket) {
    }

    public void onFunctionCall(SparkResponseFunctionCall functionCall, SparkResponseUsage usage, Integer status, SparkRequest sparkRequest, SparkResponse sparkResponse, WebSocket webSocket) {
    }

    public final void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        String requestJson = null;
        try {
            requestJson = this.objectMapper.writeValueAsString((Object)this.sparkRequest);
        }
        catch (JsonProcessingException e) {
            throw new SparkException(400, "\u8bf7\u6c42\u6570\u636e SparkRequest \u5e8f\u5217\u5316\u5931\u8d25", e);
        }
        webSocket.send(requestJson);
    }

    public final void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
        SparkResponse sparkResponse;
        try {
            sparkResponse = (SparkResponse)this.objectMapper.readValue(text, SparkResponse.class);
        }
        catch (JsonProcessingException e) {
            webSocket.close(1000, "");
            throw new SparkException(500, "\u54cd\u5e94\u6570\u636e SparkResponse \u89e3\u6790\u5931\u8d25\uff1a" + text, e);
        }
        SparkResponseHeader header = sparkResponse.getHeader();
        if (null == header) {
            webSocket.close(1000, "");
            throw new SparkException(500, "\u54cd\u5e94\u6570\u636e\u4e0d\u5b8c\u6574 SparkResponse.header\u4e3anull\uff0c\u5b8c\u6574\u54cd\u5e94\uff1a" + text);
        }
        Integer code = header.getCode();
        if (0 != code) {
            webSocket.close(1000, "");
            throw SparkException.bizFailed(code);
        }
        SparkResponseChoices choices = sparkResponse.getPayload().getChoices();
        List<SparkMessage> messages = choices.getText();
        StringBuilder stringBuilder = new StringBuilder();
        SparkResponseFunctionCall functionCall = null;
        SparkResponseUsage usage = sparkResponse.getPayload().getUsage();
        Integer status = header.getStatus();
        for (SparkMessage message : messages) {
            if (message.getFunction_call() != null) {
                functionCall = message.getFunction_call();
                break;
            }
            stringBuilder.append(message.getContent());
        }
        if (functionCall != null) {
            this.onFunctionCall(functionCall, usage, status, this.sparkRequest, sparkResponse, webSocket);
        } else {
            String content = stringBuilder.toString();
            this.onMessage(content, usage, status, this.sparkRequest, sparkResponse, webSocket);
        }
        if (2 == status) {
            webSocket.close(1000, "");
        }
    }

    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, Response response) {
        logger.error("\u8baf\u98de\u661f\u706bapi\u53d1\u751f\u5f02\u5e38\uff1a", t);
    }

    public SparkRequest getSparkRequest() {
        return this.sparkRequest;
    }

    public void setSparkRequest(SparkRequest sparkRequest) {
        this.sparkRequest = sparkRequest;
    }
}

