/*
 * Decompiled with CFR 0.152.
 */
package io.github.briqt.spark4j.model;

import io.github.briqt.spark4j.constant.SparkApiVersion;
import io.github.briqt.spark4j.model.SparkChatParameter;
import io.github.briqt.spark4j.model.SparkMessage;
import io.github.briqt.spark4j.model.request.SparkRequest;
import io.github.briqt.spark4j.model.request.SparkRequestHeader;
import io.github.briqt.spark4j.model.request.SparkRequestMessage;
import io.github.briqt.spark4j.model.request.SparkRequestParameter;
import io.github.briqt.spark4j.model.request.SparkRequestPayload;
import io.github.briqt.spark4j.model.request.function.SparkRequestFunctionMessage;
import io.github.briqt.spark4j.model.request.function.SparkRequestFunctions;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkRequestBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SparkRequestBuilder.class);
    private final SparkRequest sparkRequest = new SparkRequest();

    public SparkRequestBuilder() {
        this.sparkRequest.setHeader(new SparkRequestHeader());
        this.sparkRequest.setParameter(new SparkRequestParameter(new SparkChatParameter()));
        this.sparkRequest.setPayload(new SparkRequestPayload(new SparkRequestMessage(new ArrayList<SparkMessage>())));
    }

    public SparkRequest build() {
        SparkApiVersion apiVersion = this.sparkRequest.getApiVersion();
        if (this.sparkRequest.getPayload().getFunctions() != null && (apiVersion == SparkApiVersion.V2_0 || apiVersion == SparkApiVersion.V1_5)) {
            logger.warn("apiVersion is {}, this version does not support functions", (Object)apiVersion.getVersion());
        }
        this.sparkRequest.getParameter().getChat().setDomain(apiVersion.getDomain());
        return this.sparkRequest;
    }

    public SparkRequestBuilder messages(List<SparkMessage> messages) {
        this.sparkRequest.getPayload().getMessage().setText(messages);
        return this;
    }

    public SparkRequestBuilder temperature(Double temperature) {
        this.sparkRequest.getParameter().getChat().setTemperature(temperature);
        return this;
    }

    public SparkRequestBuilder maxTokens(Integer maxTokens) {
        this.sparkRequest.getParameter().getChat().setMaxTokens(maxTokens);
        return this;
    }

    public SparkRequestBuilder topK(Integer topK) {
        this.sparkRequest.getParameter().getChat().setTopK(topK);
        return this;
    }

    public SparkRequestBuilder uid(String uid) {
        this.sparkRequest.getHeader().setUid(uid);
        return this;
    }

    public SparkRequestBuilder chatId(String chatId) {
        this.sparkRequest.getParameter().getChat().setChatId(chatId);
        return this;
    }

    public SparkRequestBuilder chatParameter(SparkChatParameter chatParameter) {
        this.sparkRequest.getParameter().setChat(chatParameter);
        return this;
    }

    public SparkRequestBuilder apiVersion(SparkApiVersion apiVersion) {
        this.sparkRequest.setApiVersion(apiVersion);
        this.sparkRequest.getParameter().getChat().setDomain(apiVersion.getDomain());
        return this;
    }

    public SparkRequestBuilder addFunction(SparkRequestFunctionMessage function) {
        SparkRequestFunctions functions = this.sparkRequest.getPayload().getFunctions();
        if (null == functions) {
            functions = new SparkRequestFunctions(new ArrayList<SparkRequestFunctionMessage>());
            this.sparkRequest.getPayload().setFunctions(functions);
        }
        functions.getText().add(function);
        return this;
    }
}

