/*
 * Decompiled with CFR 0.152.
 */
package io.github.burukeyou.dataframe.iframe;

import io.github.burukeyou.dataframe.iframe.AbstractWindowDataFrame;
import io.github.burukeyou.dataframe.iframe.IFrame;
import io.github.burukeyou.dataframe.iframe.function.ReplenishFunction;
import io.github.burukeyou.dataframe.iframe.item.FI2;
import io.github.burukeyou.dataframe.iframe.item.FI3;
import io.github.burukeyou.dataframe.iframe.item.FI4;
import io.github.burukeyou.dataframe.iframe.support.Join;
import io.github.burukeyou.dataframe.iframe.support.JoinOn;
import io.github.burukeyou.dataframe.iframe.support.MaxMin;
import io.github.burukeyou.dataframe.util.CollectorsPlusUtil;
import io.github.burukeyou.dataframe.util.FrameUtil;
import io.github.burukeyou.dataframe.util.ListUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataFrameImpl<T>
extends AbstractWindowDataFrame<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataFrameImpl.class);

    protected AbstractDataFrameImpl() {
    }

    protected <R> Stream<T> whereNullStream(Function<T, R> function) {
        return this.stream().filter(item -> {
            Object r = function.apply(item);
            if (r == null) {
                return true;
            }
            if (r instanceof String) {
                return "".equals(r);
            }
            return false;
        });
    }

    protected <R> Stream<T> whereNotNullStream(Function<T, R> function) {
        return this.stream().filter(item -> {
            Object r = function.apply(item);
            if (r == null) {
                return false;
            }
            if (r instanceof String) {
                return !"".equals(r);
            }
            return true;
        });
    }

    public <R extends Comparable<R>> Stream<T> whereBetweenStream(Function<T, R> function, R start, R end) {
        Stream<Object> stream = this.streamFilterNull(function);
        stream = start == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(end) <= 0) : (end == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) >= 0) : stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) >= 0 && ((Comparable)function.apply(e)).compareTo(end) <= 0));
        return stream;
    }

    public <R extends Comparable<R>> Stream<T> whereBetweenNStream(Function<T, R> function, R start, R end) {
        Stream<Object> stream = this.streamFilterNull(function);
        stream = start == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(end) < 0) : (end == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) > 0) : stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) > 0 && ((Comparable)function.apply(e)).compareTo(end) < 0));
        return stream;
    }

    public <R extends Comparable<R>> Stream<T> whereBetweenRStream(Function<T, R> function, R start, R end) {
        Stream<Object> stream = this.streamFilterNull(function);
        stream = start == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(end) <= 0) : (end == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) > 0) : stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) > 0 && ((Comparable)function.apply(e)).compareTo(end) <= 0));
        return stream;
    }

    public <R extends Comparable<R>> Stream<T> whereBetweenLStream(Function<T, R> function, R start, R end) {
        Stream<Object> stream = this.streamFilterNull(function);
        stream = start == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(end) < 0) : (end == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) >= 0) : stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) >= 0 && ((Comparable)function.apply(e)).compareTo(end) < 0));
        return stream;
    }

    public <R extends Comparable<R>> Stream<T> whereNotBetweenStream(Function<T, R> function, R start, R end) {
        return this.streamFilterNull(function).filter(e -> ((Comparable)function.apply(e)).compareTo(start) <= 0 || ((Comparable)function.apply(e)).compareTo(end) >= 0);
    }

    public <R extends Comparable<R>> Stream<T> whereNotBetweenNStream(Function<T, R> function, R start, R end) {
        return this.streamFilterNull(function).filter(e -> ((Comparable)function.apply(e)).compareTo(start) < 0 || ((Comparable)function.apply(e)).compareTo(end) > 0);
    }

    public <R> Stream<T> whereInStream(Function<T, R> function, List<R> list) {
        HashSet set = new HashSet(list);
        return this.stream().filter(e -> set.contains(function.apply(e)));
    }

    public <R> Stream<T> whereNotInStream(Function<T, R> function, List<R> list) {
        HashSet set = new HashSet(list);
        return this.stream().filter(e -> !set.contains(function.apply(e)));
    }

    public <R> Stream<T> whereEqStream(Function<T, R> function, R value) {
        return this.stream().filter(e -> value.equals(function.apply(e)));
    }

    public <R> Stream<T> whereNotEqStream(Function<T, R> function, R value) {
        return this.stream().filter(e -> !value.equals(function.apply(e)));
    }

    public <R extends Comparable<R>> Stream<T> whereGtStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> ((Comparable)function.apply(e)).compareTo(value) > 0);
    }

    public <R extends Comparable<R>> Stream<T> whereGeStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> ((Comparable)function.apply(e)).compareTo(value) >= 0);
    }

    public <R extends Comparable<R>> Stream<T> whereLtStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> ((Comparable)function.apply(e)).compareTo(value) < 0);
    }

    public <R extends Comparable<R>> Stream<T> whereLeStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> ((Comparable)function.apply(e)).compareTo(value) <= 0);
    }

    public <R> Stream<T> whereLikeStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> String.valueOf(function.apply(e)).contains(String.valueOf(value)));
    }

    public <R> Stream<T> whereNotLikeStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> !String.valueOf(function.apply(e)).contains(String.valueOf(value)));
    }

    public <R> Stream<T> whereLikeLeftStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> String.valueOf(function.apply(e)).startsWith(String.valueOf(value)));
    }

    public <R> Stream<T> whereLikeRightStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> String.valueOf(function.apply(e)).endsWith(String.valueOf(value)));
    }

    @Override
    public <R> BigDecimal sum(Function<T, R> function) {
        return this.stream().map(function).filter(Objects::nonNull).collect(CollectorsPlusUtil.summingBigDecimal(e -> {
            if (e instanceof BigDecimal) {
                return (BigDecimal)e;
            }
            return new BigDecimal(String.valueOf(e));
        }));
    }

    @Override
    public <R> BigDecimal avg(Function<T, R> function) {
        List bigDecimalList = this.stream().map(function).filter(Objects::nonNull).map((? super T e) -> {
            if (e instanceof BigDecimal) {
                return (BigDecimal)e;
            }
            return new BigDecimal(String.valueOf(e));
        }).collect(Collectors.toList());
        if (bigDecimalList.isEmpty()) {
            return null;
        }
        return bigDecimalList.stream().reduce(BigDecimal.ZERO, BigDecimal::add).divide(BigDecimal.valueOf(bigDecimalList.size()), this.defaultScale, this.defaultRoundingMode);
    }

    @Override
    public <R extends Comparable<? super R>> MaxMin<R> maxMinValue(Function<T, R> function) {
        MaxMin<T> maxAndMin = this.maxMin(function);
        return new MaxMin<Comparable>((Comparable)this.getApplyValue(function, maxAndMin.getMax()), (Comparable)this.getApplyValue(function, maxAndMin.getMin()));
    }

    @Override
    public <R extends Comparable<? super R>> MaxMin<T> maxMin(Function<T, R> function) {
        List itemList = this.stream().filter(e -> e != null && function.apply(e) != null).collect(Collectors.toList());
        if (itemList.isEmpty()) {
            return new MaxMin<Object>(null, null);
        }
        Object max = itemList.get(0);
        Object min = itemList.get(0);
        for (int i = 1; i < itemList.size(); ++i) {
            Object cur = itemList.get(i);
            Comparable curValue = (Comparable)function.apply(cur);
            Comparable maxValue = (Comparable)function.apply(max);
            Comparable minValue = (Comparable)function.apply(min);
            if (curValue.compareTo(maxValue) >= 0) {
                max = cur;
            }
            if (curValue.compareTo(minValue) > 0) continue;
            min = cur;
        }
        return new MaxMin(max, min);
    }

    @Override
    public <R extends Comparable<? super R>> R maxValue(Function<T, R> function) {
        Optional<Comparable> value = this.stream().map(function).filter(Objects::nonNull).max(Comparator.comparing(e -> e));
        return (R)((Comparable)value.orElse(null));
    }

    @Override
    public <R extends Comparable<R>> T max(Function<T, R> function) {
        Optional<Object> max = this.stream().filter(e -> function.apply(e) != null).max(Comparator.comparing(function));
        return max.orElse(null);
    }

    @Override
    public <R extends Comparable<? super R>> R minValue(Function<T, R> function) {
        Optional<Comparable> value = this.stream().map(function).filter(Objects::nonNull).min(Comparator.comparing(e -> e));
        return (R)((Comparable)value.orElse(null));
    }

    @Override
    public <R extends Comparable<R>> T min(Function<T, R> function) {
        Optional<Object> min = this.stream().filter(e -> function.apply(e) != null).min(Comparator.comparing(function));
        return min.orElse(null);
    }

    @Override
    public long count() {
        return this.stream().count();
    }

    protected <K> List<FI2<K, List<T>>> groupKey(Function<T, K> K) {
        return FrameUtil.toListFI2(this.stream().collect(Collectors.groupingBy(K)));
    }

    protected <K, V> List<FI2<K, V>> groupKey(Function<T, K> K, Collector<T, ?, V> tBigDecimalCollector) {
        Map<K, V> resultMap = this.stream().collect(Collectors.groupingBy(K, tBigDecimalCollector));
        return FrameUtil.toListFI2(resultMap);
    }

    protected <K, J, V> List<FI3<K, J, V>> groupKey(Function<T, K> K, Function<T, J> J, Collector<T, ?, V> tBigDecimalCollector) {
        Map<K, Map<J, V>> map = this.stream().collect(Collectors.groupingBy(K, Collectors.groupingBy(J, tBigDecimalCollector)));
        return FrameUtil.toListFI3(map);
    }

    protected <K, J, H, V> List<FI4<K, J, H, V>> groupKey(Function<T, K> K, Function<T, J> J, Function<T, H> H, Collector<T, ?, V> collectorType) {
        Map<K, Map<J, Map<H, V>>> map = this.stream().collect(Collectors.groupingBy(K, Collectors.groupingBy(J, Collectors.groupingBy(H, collectorType))));
        return FrameUtil.toListFI4(map);
    }

    protected <K, J, V extends Comparable<V>> Map<K, Map<J, T>> groupToMap(Function<T, K> key, Function<T, J> key2, Function<List<T>, T> getListMaxFunction) {
        return this.stream().collect(Collectors.groupingBy(key, Collectors.groupingBy(key2, Collectors.collectingAndThen(Collectors.toList(), getListMaxFunction))));
    }

    protected <V extends Comparable<? super V>> Function<List<T>, T> getListMaxFunction(Function<T, V> value) {
        return e -> e.stream().filter(a -> value.apply(a) != null).max(Comparator.comparing(value)).orElse(null);
    }

    protected <V extends Comparable<? super V>> Function<List<T>, T> getListMinFunction(Function<T, V> value) {
        return e -> e.stream().min(Comparator.comparing(value)).orElse(null);
    }

    protected <V extends Comparable<? super V>> Function<List<T>, MaxMin<V>> getListGroupMaxMinValueFunction(Function<T, V> value) {
        return list -> {
            if (list == null || list.isEmpty()) {
                return null;
            }
            MaxMin<Comparable> maxMin = new MaxMin<Comparable>();
            maxMin.setMax(list.stream().max(Comparator.comparing(value)).map(value).orElse(null));
            maxMin.setMin(list.stream().min(Comparator.comparing(value)).map(value).orElse(null));
            return maxMin;
        };
    }

    protected <V extends Comparable<? super V>> Function<List<T>, MaxMin<T>> getListGroupMaxMinFunction(Function<T, V> value) {
        return list -> {
            if (list == null || list.isEmpty()) {
                return new MaxMin();
            }
            MaxMin<Object> maxMin = new MaxMin<Object>();
            maxMin.setMax(list.stream().max(Comparator.comparing(value)).orElse(null));
            maxMin.setMin(list.stream().min(Comparator.comparing(value)).orElse(null));
            return maxMin;
        };
    }

    public <R> Stream<T> streamFilterNull(Function<T, R> function) {
        return this.stream().filter(e -> e != null && function.apply(e) != null);
    }

    @Override
    public Iterator<T> iterator() {
        return this.toLists().iterator();
    }

    protected <F> List<String> buildFieldList(F f) {
        ArrayList<String> filedList = new ArrayList<String>();
        Arrays.stream(f.getClass().getDeclaredFields()).forEach(field -> {
            field.setAccessible(true);
            filedList.add(field.getName());
        });
        return filedList;
    }

    @Override
    public List<String> columns() {
        return this.fieldList;
    }

    @Override
    public <R> List<R> col(Function<T, R> function) {
        return this.toLists().stream().map(function).collect(Collectors.toList());
    }

    @Override
    public List<T> page(int page, int pageSize) {
        int count;
        int startIndex;
        if (page < 0 || pageSize < 1) {
            throw new IllegalArgumentException("Page and pageSize must be positive integers.");
        }
        if (page == 0) {
            page = 1;
        }
        if ((startIndex = (page - 1) * pageSize) >= (count = (int)this.count())) {
            return Collections.emptyList();
        }
        int endIndex = Math.min(startIndex + pageSize, count);
        return this.toLists().subList(startIndex, endIndex);
    }

    @Override
    public void show() {
        this.show(10);
    }

    @Override
    public void show(int n) {
        String[][] dataArr = this.buildPrintDataArr(n);
        if (dataArr == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dataArr.length; ++i) {
            for (int j = 0; j < dataArr[0].length; ++j) {
                sb.append(dataArr[i][j].replace("****", "\t"));
            }
        }
        System.out.println(sb);
    }

    protected <R, K> List<R> joinList(IFrame<K> other, JoinOn<T, K> on, Join<T, K, R> join) {
        ArrayList<R> resultList = new ArrayList<R>();
        for (T cur : this) {
            for (Object k : other) {
                if (!on.on(cur, k)) continue;
                resultList.add(join.join(cur, k));
            }
        }
        return resultList;
    }

    protected <R, K> List<R> leftJoinList(IFrame<K> other, JoinOn<T, K> on, Join<T, K, R> join) {
        ArrayList<R> resultList = new ArrayList<R>();
        for (T cur : this) {
            for (Object k : other) {
                if (on.on(cur, k)) {
                    resultList.add(join.join(cur, k));
                    continue;
                }
                resultList.add(join.join(cur, null));
            }
        }
        return resultList;
    }

    protected <R, K> List<R> rightJoinList(IFrame<K> other, JoinOn<T, K> on, Join<T, K, R> join) {
        ArrayList<R> resultList = new ArrayList<R>();
        for (Object k : other) {
            for (T cur : this) {
                if (on.on(cur, k)) {
                    resultList.add(join.join(cur, k));
                    continue;
                }
                resultList.add(join.join(null, k));
            }
        }
        return resultList;
    }

    @Override
    public List<T> head(int n) {
        List tsList = this.toLists();
        if (tsList.isEmpty()) {
            return Collections.emptyList();
        }
        if (n >= tsList.size()) {
            return tsList;
        }
        return tsList.subList(0, n);
    }

    @Override
    public List<T> tail(int n) {
        List tsList = this.toLists();
        if (tsList.isEmpty()) {
            return Collections.emptyList();
        }
        if (n >= tsList.size()) {
            return tsList;
        }
        return tsList.subList(tsList.size() - 1 - n + 1, tsList.size());
    }

    @Override
    public T head() {
        List ts = this.toLists();
        return ts.isEmpty() ? null : (T)ts.get(0);
    }

    @Override
    public T tail() {
        List ts = this.toLists();
        return ts.isEmpty() ? null : (T)ts.get(ts.size() - 1);
    }

    @Override
    public List<T> subList(Integer startIndex, Integer endIndex) {
        List ts = this.toLists();
        if (startIndex == null || startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex == null || endIndex > ts.size()) {
            endIndex = ts.size();
        }
        return ts.subList(startIndex, endIndex);
    }

    protected static <T, C> List<T> replenish(List<T> itemDTOList, Function<T, C> collectDim, List<C> allDim, Function<C, T> getEmptyObject) {
        allDim = new ArrayList<C>(new HashSet<C>(allDim));
        List collect = itemDTOList.stream().map(collectDim).collect(Collectors.toList());
        collect = new ArrayList(new HashSet(collect));
        allDim.removeAll(collect);
        List collect1 = allDim.stream().map(getEmptyObject).collect(Collectors.toList());
        itemDTOList.addAll(collect1);
        return itemDTOList;
    }

    public static <T, G, C> List<T> replenish(List<T> itemDTOList, Function<T, G> groupDim, Function<T, C> collectDim, List<C> allDim, ReplenishFunction<G, C, T> getEmptyObject) {
        Map<G, List<T>> nameItemListMap = itemDTOList.stream().collect(Collectors.groupingBy(groupDim));
        nameItemListMap.forEach((? super K name, ? super V itemList) -> {
            ArrayList tmpAll = new ArrayList(allDim);
            List abasicssaList = itemList.stream().map(collectDim).collect(Collectors.toList());
            tmpAll.removeAll(abasicssaList);
            if (ListUtils.isNotEmpty(tmpAll)) {
                List missingList = tmpAll.stream().map((? super T e) -> getEmptyObject.apply(name, e)).collect(Collectors.toList());
                itemList.addAll(missingList);
            }
        });
        return nameItemListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected static <T, G, C> List<T> replenish(List<T> itemDTOList, Function<T, G> groupDim, Function<T, C> collectDim, ReplenishFunction<G, C, T> getEmptyObject) {
        List allDim = itemDTOList.stream().map(collectDim).filter(Objects::nonNull).collect(Collectors.toList());
        allDim = new ArrayList(new HashSet(allDim));
        return AbstractDataFrameImpl.replenish(itemDTOList, groupDim, collectDim, allDim, getEmptyObject);
    }

    protected static <C> List<C> mergeCollection(Collection<List<C>> values) {
        List allAbscissa = values.stream().flatMap(Collection::stream).collect(Collectors.toList());
        allAbscissa = new HashSet(allAbscissa).stream().collect(Collectors.toList());
        return allAbscissa;
    }

    protected <R> R getApplyValue(Function<T, R> fun, T obj) {
        return obj == null ? null : (R)fun.apply(obj);
    }
}

