/*
 * (c) copyright 2015-2019 Bernd Wengenroth
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package com.bw.jtools.ui;

import com.bw.jtools.Application;
import java.awt.Dimension;

/**
 * Frame to show an internal html document.
 */
public class HtmlViewer extends javax.swing.JFrame {

    /**
     * Creates new form HtmlViewer
     */
    public HtmlViewer()
    {
        initComponents(0,0);

        setIconImages( IconCache.getAppIconImages());
    }

    public HtmlViewer(int width, int height)
    {
        initComponents(width,height);
        setIconImages( IconCache.getAppIconImages());
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    private void initComponents(int width, int height)
    {

        text_scroller_ = new javax.swing.JScrollPane();
        text_ = new javax.swing.JTextPane();
        close_ = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(Application.AppName);
        setResizable(true);
        if ( width > 0 && height > 0 )
            setPreferredSize(new Dimension(width,height));

        text_.setEditable(false);
        text_.setContentType("text/html"); // NOI18N
        text_scroller_.setViewportView(text_);

        close_.setText( I18N.getText("button.close"));// NOI18N
        close_.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                close_ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(text_scroller_)
            .addComponent(close_, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 857, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(text_scroller_, javax.swing.GroupLayout.DEFAULT_SIZE, 401, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(close_))
        );

        getAccessibleContext().setAccessibleName("");
        getAccessibleContext().setAccessibleDescription("");

        pack();
    }

    private void close_ActionPerformed(java.awt.event.ActionEvent evt)
    {
        dispose();
    }

    public static void show(String title, String html)
    {
        HtmlViewer hview = new HtmlViewer();
        if ( title != null )
            hview.setTitle(title);
        hview.text_.setText(html);
        hview.text_.setCaretPosition(0);
        hview.setVisible(true);
    }

    public static void show(String title, String html, int width, int height)
    {
        HtmlViewer hview = new HtmlViewer(width, height);
        if ( title != null )
            hview.setTitle(title);
        hview.text_.setText(html);
        hview.text_.setCaretPosition(0);
        hview.setVisible(true);
    }

    private javax.swing.JButton close_;
    private javax.swing.JTextPane text_;
    private javax.swing.JScrollPane text_scroller_;
}
