/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.io;

import com.bw.jtools.Log;
import com.bw.jtools.persistence.Store;
import com.bw.jtools.ui.I18N;
import com.bw.jtools.ui.IconCache;
import com.bw.jtools.ui.WaitSplash;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class IOTool {
    private static ExecutorService io_executor_;
    private static JFileChooser fileChooser_;
    private static Frame fileChooserFrame_;
    private static FileNameExtensionFilter filterJson;
    private static FileNameExtensionFilter filterLog;
    private static FileFilter filterAll;
    public static final int SAVE = 1;
    public static final int OPEN = 2;

    public static synchronized void executeIOTask(Runnable r) {
        if (io_executor_ == null) {
            io_executor_ = Executors.newCachedThreadPool();
        }
        io_executor_.execute(r);
    }

    public static Writer createTextWriter(String file) throws IOException {
        return IOTool.createTextWriter(IOTool.getPath(file));
    }

    public static Writer createTextWriter(Path file) throws IOException {
        IOTool.ensureDirectoriesForFile(file);
        return Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (Exception e) {
            Log.error("Can't resolve path " + file.getPath(), e);
            return null;
        }
    }

    public static void setWorkingDir(File path) {
        try {
            System.setProperty("user.dir", path.getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static File makeAbsolute(String relativePath) {
        return new File(relativePath).getAbsoluteFile();
    }

    public static String makeRelative(Path path) {
        try {
            return IOTool.makeRelative(path.toFile());
        }
        catch (Exception exception) {
            return path.toUri().toString();
        }
    }

    public static String makeRelative(File path) {
        if (path.isAbsolute()) {
            String absPath = path.getAbsolutePath();
            File common_dir = new File(System.getProperty("user.dir"));
            StringBuilder relPath = new StringBuilder();
            while (!absPath.startsWith(common_dir.getAbsolutePath())) {
                common_dir = common_dir.getParentFile();
                relPath.append("..");
                relPath.append(File.separator);
                if (common_dir != null) continue;
                return absPath;
            }
            if ((absPath = absPath.substring(common_dir.getAbsolutePath().length())).startsWith(File.separator)) {
                relPath.append(absPath.substring(File.separator.length()));
            } else {
                relPath.append(absPath);
            }
            return relPath.toString();
        }
        return path.getPath();
    }

    public static void ensureDirectoriesForFile(Path file) throws IOException {
        Path parent;
        if (file != null && (parent = file.getParent()) != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
            Log.info("Created " + parent);
        }
    }

    public static void setFileChooserDirectory(JFileChooser fileChooser, File dir) {
        try {
            fileChooser.setCurrentDirectory(null);
            fileChooser.setCurrentDirectory(dir);
        }
        catch (Throwable t) {
            try {
                fileChooser.setCurrentDirectory(dir);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static FileFilter getFileFilterJson() {
        if (filterJson == null) {
            filterJson = new FileNameExtensionFilter(I18N.getText("filefilter.json"), "json", "js");
        }
        return filterJson;
    }

    public static FileFilter getFileFilterLog() {
        if (filterLog == null) {
            filterLog = new FileNameExtensionFilter(I18N.getText("filefilter.log"), "log", "txt");
        }
        return filterLog;
    }

    public static FileFilter getFileFilterAll() {
        if (filterAll == null) {
            filterAll = new AllFileFilter();
        }
        return filterAll;
    }

    private static Component prepareFileChooser(Component comp) {
        if (comp == null) {
            if (null == fileChooserFrame_) {
                fileChooserFrame_ = new Frame();
                fileChooserFrame_.setIconImage(IconCache.getAppSmallImage());
            }
            comp = fileChooserFrame_;
        }
        if (null == fileChooser_) {
            fileChooser_ = new JFileChooser();
        }
        return comp;
    }

    public static File selectDirectory(Component comp, String prefPrefix, String dialogTitle, int mode) {
        int response;
        comp = IOTool.prepareFileChooser(comp);
        String dirPath = Store.getString(prefPrefix + ".dir", null);
        File dir = dirPath != null && !dirPath.isEmpty() ? new File(dirPath) : null;
        fileChooser_.setDialogTitle(dialogTitle);
        fileChooser_.setMultiSelectionEnabled(false);
        fileChooser_.setFileHidingEnabled(true);
        fileChooser_.setFileFilter(null);
        fileChooser_.setAcceptAllFileFilterUsed(true);
        fileChooser_.setFileSelectionMode(1);
        IOTool.setFileChooserDirectory(fileChooser_, dir);
        int n = response = mode == 2 ? fileChooser_.showOpenDialog(comp) : fileChooser_.showSaveDialog(comp);
        if (response == 0) {
            File file = fileChooser_.getSelectedFile().getAbsoluteFile();
            Store.setString(prefPrefix + ".dir", file.getParent());
            return file;
        }
        return null;
    }

    public static File selectFile(Component comp, String prefPrefix, String dialogTitle, int mode, FileFilter ... filter) {
        File[] f = IOTool.internal_selectFiles(comp, prefPrefix, dialogTitle, mode, filter, false);
        if (f != null && f.length > 0) {
            return f[0];
        }
        return null;
    }

    public static File[] selectFiles(Component comp, String prefPrefix, String dialogTitle, int mode, FileFilter ... filter) {
        return IOTool.internal_selectFiles(comp, prefPrefix, dialogTitle, mode, filter, true);
    }

    private static File[] internal_selectFiles(Component comp, String prefPrefix, String dialogTitle, int mode, FileFilter[] filter, boolean multiSelectionAllowed) {
        int response;
        String lastFile;
        String lastDir;
        comp = IOTool.prepareFileChooser(comp);
        if (mode == 1) {
            multiSelectionAllowed = false;
        }
        fileChooser_.setDialogTitle(dialogTitle);
        fileChooser_.setMultiSelectionEnabled(multiSelectionAllowed);
        fileChooser_.setFileHidingEnabled(true);
        fileChooser_.resetChoosableFileFilters();
        fileChooser_.setAcceptAllFileFilterUsed(false);
        boolean firstFilter = true;
        for (FileFilter f : filter) {
            if (f == null) {
                f = IOTool.getFileFilterAll();
            }
            if (firstFilter) {
                fileChooser_.setFileFilter(f);
                firstFilter = false;
                continue;
            }
            fileChooser_.addChoosableFileFilter(f);
        }
        if (prefPrefix != null) {
            lastDir = Store.getString(prefPrefix + ".dir", null);
            lastFile = multiSelectionAllowed ? null : Store.getString(prefPrefix + ".file", null);
        } else {
            lastDir = null;
            lastFile = null;
        }
        if (lastDir == null || lastFile == null) {
            fileChooser_.setSelectedFile(new File(""));
        } else {
            if (!lastDir.endsWith(File.separator)) {
                lastDir = lastDir + File.separator;
            }
            File f = new File(lastDir + lastFile);
            fileChooser_.setSelectedFile(f);
        }
        fileChooser_.setFileSelectionMode(0);
        if (lastDir != null) {
            IOTool.setFileChooserDirectory(fileChooser_, new File(lastDir));
        }
        WaitSplash.showWait(false);
        int n = response = mode == 2 ? fileChooser_.showOpenDialog(comp) : fileChooser_.showSaveDialog(comp);
        if (response == 0) {
            File[] files = null;
            if (mode == 1) {
                FileNameExtensionFilter fnef;
                String[] ext;
                FileFilter ff;
                files = new File[]{fileChooser_.getSelectedFile()};
                String fileName = files[0].getName();
                int extIndex = fileName.lastIndexOf(46);
                if (extIndex < 0 && (ff = fileChooser_.getFileFilter()) instanceof FileNameExtensionFilter && (ext = (fnef = (FileNameExtensionFilter)ff).getExtensions()) != null && ext.length > 0) {
                    files[0] = new File(files[0].getParent(), fileName + "." + ext[0]);
                }
            } else if (multiSelectionAllowed) {
                files = fileChooser_.getSelectedFiles();
                if (files != null && files.length == 0) {
                    files = null;
                }
            } else {
                files = new File[]{fileChooser_.getSelectedFile()};
            }
            if (files != null) {
                Store.setString(prefPrefix + ".dir", files[0].getParentFile().getAbsolutePath());
                if (!multiSelectionAllowed) {
                    Store.setString(prefPrefix + ".file", files[0].getName());
                }
            }
            return files;
        }
        return null;
    }

    public static Path getPath(String file) {
        block8: {
            try {
                if (file != null && !file.isEmpty()) {
                    URI uri = URI.create(file);
                    String scheme = uri.getScheme();
                    if (scheme == null) break block8;
                    if (scheme.equalsIgnoreCase("file")) {
                        return Paths.get(uri);
                    }
                    if (!scheme.equalsIgnoreCase("jar")) break block8;
                    FileSystem fs = null;
                    int si = file.indexOf("!");
                    String arc = file.substring(0, si);
                    try {
                        URI fsuri = new URI(arc);
                        try {
                            fs = FileSystems.getFileSystem(fsuri);
                        }
                        catch (FileSystemNotFoundException fsnf) {
                            fs = FileSystems.newFileSystem(fsuri, new HashMap());
                        }
                        return fs.getPath(file.substring(si + 1), new String[0]);
                    }
                    catch (Exception ex2) {
                        Log.error("Can't decode Jar URI: " + ex2.getMessage(), ex2);
                        break block8;
                    }
                }
                return null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return FileSystems.getDefault().getPath(file, new String[0]);
    }

    public static BufferedImage createImageFromComponent(JComponent comp) {
        return IOTool.createImageFromComponent(comp, new Rectangle(comp.getSize()));
    }

    public static BufferedImage createImageFromComponent(JComponent comp, Rectangle region) {
        BufferedImage image = new BufferedImage(region.width, region.height, 1);
        Graphics2D g2d = image.createGraphics();
        if (!comp.isOpaque()) {
            g2d.setColor(comp.getBackground());
            g2d.fillRect(region.x, region.y, region.width, region.height);
        }
        g2d.translate(-region.x, -region.y);
        comp.print(g2d);
        g2d.dispose();
        return image;
    }

    public static BufferedImage createImageFromBuffer(byte[] data) {
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(data));
            return image;
        }
        catch (Exception e) {
            Log.error("Failed to decode image: " + e.getMessage(), e);
            return null;
        }
    }

    public static String getRestrictedStackTrace(Throwable t, String prefix, int max_lines) {
        StringWriter sw = new StringWriter(1000);
        t.printStackTrace(new PrintWriter(sw));
        String[] lines = sw.toString().split("\\r\\n|\\n|\\r");
        StringBuilder sb = new StringBuilder(2048);
        int l = 0;
        while (l < max_lines && l < lines.length) {
            sb.append(prefix).append(lines[l++]).append("\n");
        }
        if (l < lines.length) {
            sb.append(prefix).append("...\n");
        }
        return sb.toString();
    }

    static {
        fileChooser_ = null;
        fileChooserFrame_ = null;
    }

    private static class AllFileFilter
    extends FileFilter {
        final String description = I18N.getText("filefilter.all");

        private AllFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return true;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

