/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.profiling;

import com.bw.jtools.profiling.IdentifiableProfilingInformation;
import com.bw.jtools.profiling.MethodProfilingInformation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ClassProfilingInformation
extends IdentifiableProfilingInformation {
    public final String name;
    public static boolean SIMPLE_NAMES = true;
    private static final Map<String, ClassProfilingInformation> classInfo = new HashMap<String, ClassProfilingInformation>(50);
    private final Map<String, MethodProfilingInformation> methods = new HashMap<String, MethodProfilingInformation>(15);
    private static Date startOfProfiling = new Date();

    public ClassProfilingInformation(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ClassProfilingInformation> getClassInformation() {
        Map<String, ClassProfilingInformation> map = classInfo;
        synchronized (map) {
            ArrayList<ClassProfilingInformation> l = new ArrayList<ClassProfilingInformation>(classInfo.size());
            l.addAll(classInfo.values());
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearProfilingInformation() {
        Map<String, ClassProfilingInformation> map = classInfo;
        synchronized (map) {
            startOfProfiling = new Date();
            for (ClassProfilingInformation ci : classInfo.values()) {
                ci.clear();
            }
        }
    }

    public static Date getProfilingStartTime() {
        return startOfProfiling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassProfilingInformation getClassInformation(String clazz) {
        ClassProfilingInformation ci;
        Map<String, ClassProfilingInformation> map = classInfo;
        synchronized (map) {
            ci = classInfo.get(clazz);
            if (ci == null) {
                ci = new ClassProfilingInformation(clazz);
                classInfo.put(clazz, ci);
            }
        }
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MethodProfilingInformation> getMethodInformation() {
        Map<String, MethodProfilingInformation> map = this.methods;
        synchronized (map) {
            ArrayList<MethodProfilingInformation> l = new ArrayList<MethodProfilingInformation>(this.methods.size());
            l.addAll(this.methods.values());
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodProfilingInformation getMethodInformation(String methodName) {
        Map<String, MethodProfilingInformation> map = this.methods;
        synchronized (map) {
            MethodProfilingInformation mi = this.methods.get(methodName);
            if (mi == null) {
                mi = new MethodProfilingInformation(this, methodName);
                this.methods.put(methodName, mi);
            }
            return mi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<String, MethodProfilingInformation> map = this.methods;
        synchronized (map) {
            for (MethodProfilingInformation mi : this.methods.values()) {
                mi.clear();
            }
        }
    }
}

