/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.profiling;

import com.bw.jtools.profiling.CalleeProfilingInformation;
import com.bw.jtools.profiling.ClassProfilingInformation;
import com.bw.jtools.profiling.IdentifiableProfilingInformation;
import com.bw.jtools.profiling.ThreadProfilingInformation;
import com.bw.jtools.profiling.measurement.MeasurementValue;
import java.util.HashMap;
import java.util.Map;

public final class MethodProfilingInformation
extends IdentifiableProfilingInformation {
    public final String name;
    public final ClassProfilingInformation clazz;
    public int exceptions = 0;
    public final Map<Integer, CalleeProfilingInformation> callees = new HashMap<Integer, CalleeProfilingInformation>(13);

    public MethodProfilingInformation(ClassProfilingInformation clazz, String name) {
        this.clazz = clazz;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalleeProfilingInformation getCalleeInformation(MethodProfilingInformation mi) {
        Map<Integer, CalleeProfilingInformation> map = this.callees;
        synchronized (map) {
            CalleeProfilingInformation ci = this.callees.get(mi.ID);
            if (ci == null) {
                ci = new CalleeProfilingInformation(mi);
                this.callees.put(mi.ID, ci);
            }
            return ci;
        }
    }

    public boolean startCall() {
        return ThreadProfilingInformation.getInstance().pushMethod(this);
    }

    public void endCall(MeasurementValue usedValue, boolean notRecursive) {
        this.addCall(usedValue, notRecursive);
        if (notRecursive) {
            ThreadProfilingInformation ti = ThreadProfilingInformation.getInstance();
            ti.popMethod(this);
            MethodProfilingInformation mi = ti.getCurrentMethod();
            if (mi != null) {
                CalleeProfilingInformation ci = mi.getCalleeInformation(this);
                ci.addCall(usedValue, notRecursive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        super.clear();
        this.exceptions = 0;
        Map<Integer, CalleeProfilingInformation> map = this.callees;
        synchronized (map) {
            this.callees.clear();
        }
    }
}

