/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.profiling.callgraph;

import com.bw.jtools.profiling.CalleeProfilingInformation;
import com.bw.jtools.profiling.ClassProfilingInformation;
import com.bw.jtools.profiling.MethodProfilingInformation;
import com.bw.jtools.profiling.callgraph.CallEdge;
import com.bw.jtools.profiling.callgraph.CallNode;
import com.bw.jtools.profiling.callgraph.Options;
import com.bw.jtools.profiling.measurement.AbstractMeasurementSource;
import com.bw.jtools.profiling.measurement.MeasurementValue;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractCallGraphRenderer {
    protected NumberFormat nf;
    protected StringBuilder sb = new StringBuilder(1024);
    protected boolean showClassName = false;
    protected boolean hightlightCritical = false;
    protected boolean showMinMax = false;
    protected boolean pretty = false;

    protected AbstractCallGraphRenderer(NumberFormat nf, Options ... options) {
        this.nf = nf;
        block6: for (Options option : options) {
            switch (option) {
                case ADD_CLASSNAMES: {
                    this.showClassName = true;
                    continue block6;
                }
                case ADD_MIN_MAX: {
                    this.showMinMax = true;
                    continue block6;
                }
                case HIGHLIGHT_CRITICAL: {
                    this.hightlightCritical = true;
                    continue block6;
                }
                case PRETTY: {
                    this.pretty = true;
                }
            }
        }
    }

    protected String renderValue(MeasurementValue value) {
        return AbstractMeasurementSource.format(this.nf, value);
    }

    public final String render(MethodProfilingInformation root) {
        return this.render(this.generateNode(root, new GraphStack()));
    }

    public final String render(CallNode root) {
        this.sb.setLength(0);
        this.start(root);
        this.renderNode(root);
        this.end(root);
        return this.sb.toString();
    }

    private CallNode generateNode(MethodProfilingInformation mi, GraphStack g) {
        String name = this.showClassName && mi.clazz != null ? mi.clazz.name + '.' + mi.name : mi.name;
        CallNode node = new CallNode(name, mi.calls, mi.sum);
        if (this.showMinMax) {
            node.details.add("Minimum " + this.renderValue(mi.minMeasurement));
            node.details.add("Maximum " + this.renderValue(mi.maxMeasurement));
        }
        CalleeProfilingInformation highlight = null;
        if (this.hightlightCritical) {
            MeasurementValue v = null;
            for (CalleeProfilingInformation ci : mi.callees.values()) {
                if (v != null && !v.lessThan(ci.sum)) continue;
                highlight = ci;
                v = ci.sum;
            }
        }
        for (CalleeProfilingInformation ci : mi.callees.values()) {
            CallNode callee;
            if (!g.onStack(ci.callee)) {
                callee = this.generateNode(ci.callee, g);
                g.pop(ci.callee);
            } else {
                callee = null;
            }
            CallEdge ce = new CallEdge(ci.sum, ci.calls, callee);
            ce.hightlight = highlight == ci;
            node.edges.add(ce);
        }
        return node;
    }

    public final String render(List<MethodProfilingInformation> roots, Date startDate, Date endDate) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CallNode fakeRoot = new CallNode("Application", 0, null);
        if (startDate != null) {
            fakeRoot.details.add("Start: " + dateFormatter.format(startDate));
        }
        if (endDate != null) {
            fakeRoot.details.add("End: " + dateFormatter.format(endDate));
        }
        for (MethodProfilingInformation n : roots) {
            fakeRoot.edges.add(new CallEdge(null, 0, this.generateNode(n, new GraphStack())));
        }
        return this.render(fakeRoot);
    }

    private void renderNode(CallNode node) {
        this.startNode(node);
        for (CallEdge e : node.edges) {
            this.renderEdge(e);
        }
        this.endNode(node);
    }

    private void renderEdge(CallEdge edge) {
        this.startEdge(edge);
        this.renderNode(edge.callee);
        this.endEdge(edge);
    }

    public static List<MethodProfilingInformation> filterTopLevelCalls(Collection<ClassProfilingInformation> cis) {
        HashSet<Integer> callees = new HashSet<Integer>(cis.size() * 3);
        int count = 0;
        for (ClassProfilingInformation cli : cis) {
            List<MethodProfilingInformation> mis = cli.getMethodInformation();
            count += mis.size();
            for (MethodProfilingInformation mi : mis) {
                for (CalleeProfilingInformation ci : mi.callees.values()) {
                    callees.add(ci.callee.ID);
                }
            }
        }
        ArrayList<MethodProfilingInformation> l = new ArrayList<MethodProfilingInformation>(count - callees.size());
        for (ClassProfilingInformation cli : cis) {
            List<MethodProfilingInformation> mis = cli.getMethodInformation();
            for (MethodProfilingInformation mi : mis) {
                if (callees.contains(mi.ID)) continue;
                l.add(mi);
            }
        }
        return l;
    }

    protected abstract void start(CallNode var1);

    protected abstract void startNode(CallNode var1);

    protected abstract void endNode(CallNode var1);

    protected abstract void startEdge(CallEdge var1);

    protected abstract void endEdge(CallEdge var1);

    protected abstract void end(CallNode var1);

    public static final class GraphStack {
        private Set<Integer> idsOnStack = new HashSet<Integer>();

        private GraphStack() {
        }

        public boolean onStack(MethodProfilingInformation callee) {
            if (this.idsOnStack.contains(callee.ID)) {
                return true;
            }
            this.idsOnStack.add(callee.ID);
            return false;
        }

        public void pop(MethodProfilingInformation callee) {
            this.idsOnStack.remove(callee.ID);
        }
    }
}

