/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.profiling.callgraph;

import com.bw.jtools.profiling.callgraph.CallEdge;
import com.bw.jtools.profiling.measurement.AbstractMeasurementSource;
import com.bw.jtools.profiling.measurement.MeasurementValue;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public final class CallNode {
    public final String name;
    public List<String> details;
    public final int calls;
    public final MeasurementValue value;
    public MeasurementValue netValue;
    public final List<CallEdge> edges;

    public CallNode(String name, int calls, MeasurementValue value) {
        this.name = name;
        this.calls = calls;
        this.value = value == null ? null : value.clone();
        this.details = new ArrayList<String>();
        this.edges = new ArrayList<CallEdge>();
    }

    public String toString(NumberFormat nf) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.name);
        if (this.value != null) {
            sb.append(' ').append(AbstractMeasurementSource.format(nf, this.value)).append(", net ").append(AbstractMeasurementSource.format(nf, this.getNetMeasurement()));
        }
        return sb.toString();
    }

    public final MeasurementValue getNetMeasurement() {
        if (this.netValue == null && this.value != null) {
            MeasurementValue net = this.value.clone();
            for (CallEdge e : this.edges) {
                net.subtract(e.value);
            }
            this.netValue = net;
        }
        return this.netValue;
    }
}

