/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.profiling.callgraph;

import com.bw.jtools.profiling.callgraph.AbstractCallGraphRenderer;
import com.bw.jtools.profiling.callgraph.CallEdge;
import com.bw.jtools.profiling.callgraph.CallNode;
import com.bw.jtools.profiling.callgraph.Options;
import java.text.NumberFormat;

public class FreeMindGraphRenderer
extends AbstractCallGraphRenderer {
    private boolean root = true;
    private CallEdge edge = null;

    public FreeMindGraphRenderer(NumberFormat nf, Options ... options) {
        super(nf, options);
    }

    @Override
    protected void start(CallNode root) {
        this.sb.append("<map version=\"freeplane 1.7.0\">\n");
        this.edge = null;
    }

    @Override
    protected void startNode(CallNode node) {
        this.sb.append("<node STYLE=\"");
        if (this.root) {
            this.sb.append("oval");
        } else {
            this.sb.append("bubble");
        }
        this.sb.append("\"><richcontent TYPE=\"NODE\"><html><body><p><b><font size=\"3\">");
        this.appendEscaped(node.name);
        this.sb.append("</font></b></p>");
        if (node.value != null) {
            if (this.edge != null && this.edge.value != null) {
                this.sb.append("<p>");
                this.appendEscaped(this.renderValue(this.edge.value));
                this.sb.append(" in ").append(this.edge.count).append(" call");
                if (this.edge.count > 1) {
                    this.sb.append('s');
                }
                this.sb.append(".</p>");
            }
            this.sb.append("<p>Global: ");
            this.appendEscaped(this.renderValue(node.value));
            this.sb.append(" / <b>Net ");
            this.appendEscaped(this.renderValue(node.getNetMeasurement()));
            this.sb.append("</b> in ").append(node.calls).append(" call");
            if (node.calls > 1) {
                this.sb.append('s');
            }
            this.sb.append(".</p>");
        }
        this.sb.append("</body></html></richcontent>");
        if (node.details != null && !node.details.isEmpty()) {
            this.sb.append("<richcontent TYPE=\"DETAILS\" HIDDEN=\"true\"><html><body style=\"text-align: right\"><i>");
            for (int i = 0; i < node.details.size(); ++i) {
                this.sb.append("<p>");
                this.appendEscaped(node.details.get(i));
                this.sb.append("</p>");
            }
            this.sb.append("</i></body></html></richcontent>");
        }
        if (this.edge != null) {
            if (this.edge.value == null) {
                this.sb.append("<cloud COLOR=\"#ffffff\" SHAPE=\"ARC\"/>");
                this.sb.append("<edge WIDTH=\"1\" DASH=\"CLOSE_DOTS\"/>");
            } else if (this.edge.hightlight) {
                this.sb.append("<edge WIDTH=\"4\" DASH=\"SOLID\"/>");
            } else {
                this.sb.append("<edge WIDTH=\"1\" DASH=\"SOLID\"/>");
            }
        }
        if (this.root) {
            this.root = false;
        }
        this.sb.append('\n');
    }

    @Override
    protected void endNode(CallNode node) {
        this.sb.append("</node>\n");
    }

    @Override
    protected void startEdge(CallEdge edge) {
        this.edge = edge;
    }

    @Override
    protected void endEdge(CallEdge edge) {
        edge = null;
    }

    @Override
    protected void end(CallNode root) {
        this.sb.append("</map>");
    }

    private void appendEscaped(String text) {
        char[] data;
        block8: for (char c : data = text.toCharArray()) {
            switch (c) {
                case '<': {
                    this.sb.append("&lt;");
                    continue block8;
                }
                case '>': {
                    this.sb.append("&gt;");
                    continue block8;
                }
                case '&': {
                    this.sb.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    this.sb.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    this.sb.append("&apos;");
                    continue block8;
                }
                case '\n': {
                    this.sb.append("&#xa;");
                    continue block8;
                }
                default: {
                    this.sb.append(c);
                }
            }
        }
    }
}

