/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.profiling.callgraph;

import com.bw.jtools.Log;
import com.bw.jtools.io.JsonTool;
import com.bw.jtools.profiling.callgraph.CallEdge;
import com.bw.jtools.profiling.callgraph.CallNode;
import com.bw.jtools.profiling.measurement.MeasurementValue;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonValue;

public class JSONCallGraphParser {
    static final String plong = "{\t\"title\": \"CallGraph\",";
    static final String pshort = "{\"t\":\"CallGraph\"";
    static final String elong = "\"version\": 1}";
    static final String eshort = ",\"v\":1}";
    boolean inGraph;
    boolean formatShort;
    StringBuilder graph = new StringBuilder(2048);
    StringBuilder chunkBuffer = new StringBuilder(2048);
    String endPattern = null;
    ArrayList<GraphInfo> callGraphs = new ArrayList();

    public JSONCallGraphParser(Reader reader) {
        this.parse(reader);
    }

    public JSONCallGraphParser() {
        this.reset();
    }

    public void parse(Reader reader) {
        this.reset();
        LineNumberReader lr = reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader);
        try {
            String line;
            do {
                line = lr.readLine();
                this.parse(line);
            } while (line != null);
        }
        catch (Exception e) {
            Log.error("Failed to parse call-graph.", e);
        }
    }

    public void reset() {
        this.endPattern = null;
        this.inGraph = false;
        this.formatShort = false;
        this.graph.setLength(0);
        this.chunkBuffer.setLength(0);
    }

    public void parse(String chunk) {
        if (chunk != null) {
            if (this.chunkBuffer.length() > 200) {
                this.chunkBuffer.delete(0, this.chunkBuffer.length() - plong.length());
            }
            int startIndex = 0;
            do {
                int oldLength;
                if (this.inGraph) {
                    oldLength = this.graph.length();
                    this.appendText(this.graph, chunk, startIndex, chunk.length());
                    int graphEndIndex = this.graph.indexOf(this.endPattern);
                    if (graphEndIndex >= 0) {
                        this.graph.setLength(graphEndIndex += this.endPattern.length());
                        this.parseGraph(this.graph, this.formatShort);
                        this.graph.setLength(0);
                        startIndex += graphEndIndex - oldLength;
                        this.inGraph = false;
                        continue;
                    }
                    startIndex = -1;
                    continue;
                }
                oldLength = this.chunkBuffer.length();
                this.appendText(this.chunkBuffer, chunk, startIndex, chunk.length());
                int bufferStartIndex = this.chunkBuffer.indexOf(pshort, startIndex);
                if (bufferStartIndex >= 0) {
                    this.inGraph = true;
                    this.formatShort = true;
                    this.endPattern = eshort;
                    this.graph.append(pshort);
                    chunk = this.chunkBuffer.substring(bufferStartIndex + pshort.length());
                    startIndex = 0;
                    this.chunkBuffer.setLength(0);
                    continue;
                }
                bufferStartIndex = this.chunkBuffer.indexOf(plong, startIndex);
                if (bufferStartIndex >= 0) {
                    this.inGraph = true;
                    this.formatShort = false;
                    this.endPattern = elong;
                    this.graph.append(plong);
                    chunk = this.chunkBuffer.substring(bufferStartIndex + plong.length());
                    startIndex = 0;
                    this.chunkBuffer.setLength(0);
                    continue;
                }
                startIndex = -1;
            } while (startIndex >= 0);
        }
    }

    protected final void appendText(StringBuilder buffer, String chunk, int start, int end) {
        buffer.ensureCapacity(buffer.length() + (end - start));
        for (int i = start; i < end; ++i) {
            char c = chunk.charAt(i);
            if (c == '\r' || c == '\n') continue;
            buffer.append(c);
        }
    }

    public GraphInfo[] getCallGraphs() {
        return this.callGraphs.toArray(new GraphInfo[0]);
    }

    public int getNumberOfCallGraphs() {
        return this.callGraphs.size();
    }

    private void parseGraph(CharSequence graph, boolean formatShort) {
        String graphSource = graph.toString();
        JsonObject json = JsonTool.parseJson(graphSource);
        if (json == null) {
            Log.warn("Failed to parse graph.");
            System.err.println(graph);
        } else {
            this.callGraphs.add(new GraphInfo(graphSource, this.parseJsonMethod(JsonTool.getJsonObject((JsonValue)json, formatShort ? "C" : "Call"), formatShort)));
        }
    }

    private CallNode parseJsonMethod(JsonObject js, boolean formatShort) {
        JsonArray calls;
        CallNode node = new CallNode(JsonTool.getJsonString((JsonValue)js, formatShort ? "n" : "name"), JsonTool.getJsonInt((JsonValue)js, formatShort ? "c" : "calls", 0), this.parseMeasurementValue(JsonTool.getJsonValue((JsonValue)js, formatShort ? "t" : "time")));
        node.netValue = this.parseMeasurementValue(JsonTool.getJsonValue((JsonValue)js, formatShort ? "s" : "self"));
        JsonArray details = JsonTool.getJsonArray((JsonValue)js, formatShort ? "d" : "details");
        if (details != null) {
            for (JsonValue v : details) {
                node.details.add(JsonTool.getJsonString(v, null));
            }
        }
        if ((calls = JsonTool.getJsonArray((JsonValue)js, formatShort ? "u" : "using")) != null) {
            for (JsonValue cv : calls) {
                CallNode callee = this.parseJsonMethod(JsonTool.getJsonObject(cv, formatShort ? "C" : "Call"), formatShort);
                CallEdge edge = new CallEdge(this.parseMeasurementValue(JsonTool.getJsonValue(cv, formatShort ? "t" : "time")), JsonTool.getJsonInt(cv, formatShort ? "c" : "count", 0), callee);
                edge.hightlight = JsonTool.getJsonBoolean(cv, formatShort ? "h" : "highlight", false);
                node.edges.add(edge);
            }
        }
        return node;
    }

    private MeasurementValue parseMeasurementValue(JsonValue value) {
        MeasurementValue v = null;
        if (value instanceof JsonArray) {
            JsonArray ar = (JsonArray)value;
            long[] data = new long[ar.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = ((JsonNumber)ar.get(i)).intValue();
            }
            v = new MeasurementValue(data);
        } else if (value != null) {
            v = new MeasurementValue(new long[]{JsonTool.getJsonInt(value, "", 0)});
        }
        return v;
    }

    public static class GraphInfo {
        public final String source;
        public final CallNode root;

        private GraphInfo(String source, CallNode root) {
            this.source = source;
            this.root = root;
        }
    }
}

