/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.profiling.callgraph;

import com.bw.jtools.profiling.callgraph.AbstractCallGraphRenderer;
import com.bw.jtools.profiling.callgraph.CallEdge;
import com.bw.jtools.profiling.callgraph.CallNode;
import com.bw.jtools.profiling.callgraph.Options;
import com.bw.jtools.profiling.measurement.MeasurementValue;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.Deque;

public class JSONCallGraphRenderer
extends AbstractCallGraphRenderer {
    protected StringBuilder prefix;
    protected static final String nullString = "null";
    protected static final String trueString = "true";
    protected static final String falseString = "false";
    protected State state;
    protected Deque<State> stack = new ArrayDeque<State>(10);

    public JSONCallGraphRenderer(NumberFormat nf, Options ... options) {
        super(nf, options);
        if (nf instanceof DecimalFormat) {
            DecimalFormatSymbols ds = ((DecimalFormat)nf).getDecimalFormatSymbols();
            ds.setDecimalSeparator('.');
            ((DecimalFormat)nf).setDecimalFormatSymbols(ds);
        }
        nf.setGroupingUsed(false);
        if (this.pretty) {
            this.prefix = new StringBuilder(20);
        }
    }

    @Override
    protected void start(CallNode root) {
        this.sb.append("{");
        if (this.pretty) {
            this.prefix.setLength(0);
            this.prefix.append('\t');
        }
        this.stack.clear();
        this.state = State.OBJECT_START;
        this.element("title", "CallGraph");
    }

    @Override
    protected void startNode(CallNode node) {
        this.startObject("Call");
        this.element("name", node.name);
        if (node.calls > 0) {
            this.element("calls", node.calls);
        }
        if (node.details != null && !node.details.isEmpty()) {
            this.startArray("details");
            for (String t : node.details) {
                this.element("", t);
            }
            this.endArray();
        }
        if (node.value != null) {
            this.addValue("time", node.value);
            this.addValue("self", node.getNetMeasurement());
        }
        this.startArray("using");
    }

    @Override
    protected void endNode(CallNode node) {
        this.endArray();
        this.endObject();
    }

    @Override
    protected void startEdge(CallEdge edge) {
        this.startObject("edge");
        this.element("highlight", edge.hightlight);
        this.element("count", edge.count);
        this.addValue("time", edge.value);
    }

    @Override
    protected void endEdge(CallEdge edge) {
        this.endObject();
    }

    @Override
    protected void end(CallNode root) {
        this.element("version", 1.0);
        if (this.pretty) {
            this.sb.append("\n");
        }
        this.sb.append("}");
    }

    protected void appendName(String name) {
        if (this.pretty) {
            this.sb.append('\"');
            this.sb.append(name);
            this.sb.append("\": ");
        } else {
            this.sb.append('\"');
            this.sb.append(name.charAt(0));
            this.sb.append("\":");
        }
    }

    protected void prepareForNextElement() {
        switch (this.state) {
            case ARRAY_START: {
                if (this.pretty) {
                    this.sb.append("\n").append((CharSequence)this.prefix);
                }
                this.state = State.ARRAY_ADDITIONAL;
                break;
            }
            case OBJECT_START: {
                if (this.pretty) {
                    this.sb.append("\n").append((CharSequence)this.prefix);
                }
                this.state = State.OBJECT_ADDITIONAL;
                break;
            }
            case OBJECT_ADDITIONAL: 
            case ARRAY_ADDITIONAL: {
                if (this.pretty) {
                    this.sb.append(",\n").append((CharSequence)this.prefix);
                    break;
                }
                this.sb.append(',');
            }
        }
    }

    protected void startObject(String name) {
        this.prepareForNextElement();
        if (this.state == State.OBJECT_ADDITIONAL) {
            this.appendName(name);
        }
        if (this.pretty) {
            this.sb.append("{");
            this.prefix.append('\t');
        } else {
            this.sb.append('{');
        }
        this.stack.addLast(this.state);
        this.state = State.OBJECT_START;
    }

    protected void endObject() {
        if (this.pretty) {
            if (this.prefix.length() > 0) {
                this.prefix.setLength(this.prefix.length() - 1);
            }
            if (this.state == State.OBJECT_ADDITIONAL) {
                this.sb.append("\n");
                this.sb.append((CharSequence)this.prefix);
            }
            this.sb.append('}');
        } else {
            this.sb.append('}');
        }
        this.state = this.stack.removeLast();
    }

    protected void startArray(String name) {
        this.prepareForNextElement();
        if (this.state == State.OBJECT_ADDITIONAL) {
            this.appendName(name);
        }
        if (this.pretty) {
            this.sb.append("[");
            this.prefix.append('\t');
        } else {
            this.sb.append('[');
        }
        this.stack.addLast(this.state);
        this.state = State.ARRAY_START;
    }

    protected void endArray() {
        if (this.pretty) {
            if (this.prefix.length() > 0) {
                this.prefix.setLength(this.prefix.length() - 1);
            }
            if (this.state == State.ARRAY_ADDITIONAL) {
                this.sb.append("\n");
                this.sb.append((CharSequence)this.prefix);
            }
            this.sb.append(']');
        } else {
            this.sb.append(']');
        }
        this.state = this.stack.removeLast();
    }

    protected void value(String text) {
        if (text == null) {
            this.sb.append(nullString);
        } else {
            char[] data;
            this.sb.append('\"');
            block9: for (char c : data = text.toCharArray()) {
                switch (c) {
                    case '\"': {
                        this.sb.append("\\\"");
                        continue block9;
                    }
                    case '\\': {
                        this.sb.append("\\\\");
                        continue block9;
                    }
                    case '\b': {
                        this.sb.append("\\b");
                        continue block9;
                    }
                    case '\f': {
                        this.sb.append("\\f");
                        continue block9;
                    }
                    case '\n': {
                        this.sb.append("\\n");
                        continue block9;
                    }
                    case '\r': {
                        this.sb.append("\\r");
                        continue block9;
                    }
                    case '\t': {
                        this.sb.append("\\t");
                        continue block9;
                    }
                    default: {
                        this.sb.append(c);
                    }
                }
            }
            this.sb.append('\"');
        }
    }

    protected void value(Number value) {
        if (value == null) {
            this.sb.append(nullString);
        } else {
            this.sb.append(this.nf.format(value));
        }
    }

    protected void value(boolean value) {
        this.sb.append(value ? trueString : falseString);
    }

    protected void element(String name, String value) {
        this.prepareForNextElement();
        if (this.state == State.OBJECT_ADDITIONAL) {
            this.appendName(name);
        }
        this.value(value);
    }

    protected void element(String name, Number value) {
        this.prepareForNextElement();
        if (this.state == State.OBJECT_ADDITIONAL) {
            this.appendName(name);
        }
        this.value(value);
    }

    protected void element(String name, boolean value) {
        this.prepareForNextElement();
        if (this.state == State.OBJECT_ADDITIONAL) {
            this.appendName(name);
        }
        this.value(value);
    }

    protected void addValue(String name, MeasurementValue v) {
        if (v != null && v.values != null) {
            if (v.values.length == 1) {
                this.element(name, v.values[0]);
            } else if (v.values.length > 1) {
                this.startArray(name);
                for (long val : v.values) {
                    this.element("value", val);
                }
                this.endArray();
            }
        }
    }

    protected static enum State {
        OBJECT_START,
        OBJECT_ADDITIONAL,
        ARRAY_START,
        ARRAY_ADDITIONAL;

    }
}

