/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui;

import com.bw.jtools.Application;
import com.bw.jtools.ui.I18N;
import com.bw.jtools.ui.IconCache;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;

public class HtmlViewer
extends JFrame {
    private JButton close_;
    private JTextPane text_;
    private JScrollPane text_scroller_;

    public HtmlViewer() {
        this.initComponents(0, 0);
        this.setIconImages(IconCache.getAppIconImages());
    }

    public HtmlViewer(int width, int height) {
        this.initComponents(width, height);
        this.setIconImages(IconCache.getAppIconImages());
    }

    private void initComponents(int width, int height) {
        this.text_scroller_ = new JScrollPane();
        this.text_ = new JTextPane();
        this.close_ = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(Application.AppName);
        this.setResizable(true);
        if (width > 0 && height > 0) {
            this.setPreferredSize(new Dimension(width, height));
        }
        this.text_.setEditable(false);
        this.text_.setContentType("text/html");
        this.text_scroller_.setViewportView(this.text_);
        this.close_.setText(I18N.getText("button.close"));
        this.close_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlViewer.this.close_ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.text_scroller_).addComponent(this.close_, GroupLayout.Alignment.TRAILING, -1, 857, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.text_scroller_, -1, 401, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.close_)));
        this.getAccessibleContext().setAccessibleName("");
        this.getAccessibleContext().setAccessibleDescription("");
        this.pack();
    }

    private void close_ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void show(String title, String html) {
        HtmlViewer hview = new HtmlViewer();
        if (title != null) {
            hview.setTitle(title);
        }
        hview.text_.setText(html);
        hview.text_.setCaretPosition(0);
        hview.setVisible(true);
    }

    public static void show(String title, String html, int width, int height) {
        HtmlViewer hview = new HtmlViewer(width, height);
        if (title != null) {
            hview.setTitle(title);
        }
        hview.text_.setText(html);
        hview.text_.setCaretPosition(0);
        hview.setVisible(true);
    }
}

