/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui;

import com.bw.jtools.Log;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Locale;
import java.util.ResourceBundle;

public final class I18N {
    private static Locale currentLocale_;
    private static ArrayList<BundleInfo> resourceBundles_;
    private static final String empty_string = "";

    public static void setLocale(Locale locale) {
        Locale newLocale;
        Locale locale2 = newLocale = null == locale ? Locale.getDefault() : locale;
        if (currentLocale_ == null || !currentLocale_.equals(newLocale)) {
            currentLocale_ = newLocale;
            for (BundleInfo bi : resourceBundles_) {
                bi.bundle_ = ResourceBundle.getBundle(bi.name_, currentLocale_, bi.clazz_.getClassLoader());
            }
        }
    }

    public static void addBundle(String name, Class clazz) {
        BundleInfo bi = new BundleInfo();
        bi.name_ = name;
        bi.clazz_ = clazz;
        bi.bundle_ = null;
        try {
            bi.bundle_ = ResourceBundle.getBundle(name, currentLocale_, clazz.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bi.bundle_ == null) {
            Log.warn("Failed to load bundle '" + name + "' by class-loader for " + clazz.getSimpleName());
        } else {
            resourceBundles_.add(0, bi);
        }
    }

    public static String getText(String key) {
        for (BundleInfo bi : resourceBundles_) {
            try {
                String text = bi.bundle_.getString(key);
                if (text == null || text.isEmpty()) continue;
                return text;
            }
            catch (Exception exception) {
            }
        }
        Log.warn("Missing i18n text '" + key + "'");
        return key;
    }

    public static boolean hasText(String key) {
        for (BundleInfo bi : resourceBundles_) {
            try {
                String text = bi.bundle_.getString(key);
                if (text == null || text.isEmpty()) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public static String format(String key, Object ... arguments) {
        String f = I18N.getText(key);
        if (f != null) {
            Formatter formatter = new Formatter(currentLocale_);
            formatter.format(f, arguments);
            return formatter.out().toString();
        }
        return empty_string;
    }

    static {
        resourceBundles_ = new ArrayList();
        I18N.setLocale(null);
        I18N.addBundle("com.bw.jtools.ui.i18n", I18N.class);
    }

    static class BundleInfo {
        Class clazz_;
        String name_;
        ResourceBundle bundle_;

        BundleInfo() {
        }
    }
}

