/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui;

import com.bw.jtools.Application;
import com.bw.jtools.Log;
import com.bw.jtools.ui.DummyIcon;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconCache {
    private static BufferedImage appImage = null;
    private static BufferedImage appSmallImage = null;
    private static List<BufferedImage> appIconImages = null;
    private static Icon appSmallIcon = null;
    private static Icon dummyIcon = new DummyIcon();
    private static HashMap<String, Icon> icons_ = new HashMap();

    public static BufferedImage getImage(String name) throws IOException {
        return IconCache.getImage(Application.AppClass, name);
    }

    public static BufferedImage getImage(Class clazz, String name) throws IOException {
        try (InputStream is = clazz.getResourceAsStream(name);){
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon getIcon(Class clazz, String name) {
        Icon ic;
        HashMap<String, Icon> hashMap = icons_;
        synchronized (hashMap) {
            ic = icons_.get(name);
            if (ic == null) {
                BufferedImage img;
                try {
                    img = IconCache.getImage(clazz, "icons/" + name);
                }
                catch (Exception e) {
                    Log.error("Failed to load icon " + name + ".", e);
                    img = null;
                }
                ic = img != null ? new ImageIcon(img) : dummyIcon;
                icons_.put(name, ic);
            }
        }
        return ic;
    }

    public static Icon getIcon(String name) {
        return IconCache.getIcon(Application.AppClass, name);
    }

    public static synchronized BufferedImage getAppImage(int preferredSize) {
        if (appImage == null) {
            BufferedImage bestImage = null;
            int bestDiff = Integer.MAX_VALUE;
            List<BufferedImage> images = IconCache.getAppIconImages();
            for (BufferedImage i : images) {
                int diff = (Math.abs(preferredSize - i.getHeight()) + Math.abs(preferredSize - i.getWidth())) / 2;
                if (diff >= bestDiff) continue;
                bestDiff = diff;
                bestImage = i;
            }
            return bestImage;
        }
        return appImage;
    }

    public static synchronized Icon getAppSmallIcon() {
        if (appSmallIcon == null) {
            BufferedImage img = IconCache.getAppSmallImage();
            appSmallIcon = img != null ? new ImageIcon(img) : dummyIcon;
        }
        return appSmallIcon;
    }

    public static synchronized BufferedImage getAppSmallImage() {
        if (appSmallImage == null) {
            appImage = IconCache.getAppImage(20);
        }
        return appSmallImage;
    }

    public static List<BufferedImage> getAppIconImages() {
        if (null == appIconImages) {
            appIconImages = new ArrayList<BufferedImage>();
            Arrays.asList("16", "20", "26", "28", "32", "40", "64", "128").stream().forEach(s -> {
                BufferedImage bi;
                try {
                    bi = IconCache.getImage("icons/" + Application.AppIconPrefix + "_" + s + "x" + s + ".png");
                }
                catch (Exception ex) {
                    bi = null;
                }
                if (null != bi) {
                    appIconImages.add(bi);
                }
            });
        }
        return appIconImages;
    }
}

