/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui;

import com.bw.jtools.ui.UITool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;

public final class JColorIcon
implements Icon {
    protected final int width_;
    protected final int height_;
    protected Color color_;
    protected Color borderColor_;
    protected boolean borderPainted_ = true;
    protected final BasicStroke stroke_ = new BasicStroke(1.0f);

    public JColorIcon(int width, int height, Color color) {
        this.width_ = width;
        this.height_ = height;
        this.setColor(color);
    }

    public void setBorderPainted(boolean border) {
        if (this.borderPainted_ != border) {
            this.borderPainted_ = border;
        }
    }

    public JColorIcon() {
        this.color_ = Color.WHITE;
        this.borderColor_ = Color.BLACK;
        this.width_ = 13;
        this.height_ = 13;
    }

    public void setColor(Color color) {
        this.color_ = color == null ? Color.WHITE : color;
        this.borderColor_ = UITool.calculateContrastColor(this.color_);
    }

    public Color getColor() {
        return this.color_;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2D = (Graphics2D)g.create();
        g2D.setColor(this.color_);
        g2D.fillRect(x, y, this.width_, this.height_);
        if (this.borderPainted_) {
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setColor(this.borderColor_);
            g2D.setStroke(this.stroke_);
            g2D.drawRect(x, y, this.width_, this.height_);
        }
        g2D.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.width_;
    }

    @Override
    public int getIconHeight() {
        return this.height_;
    }
}

