/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui;

import com.bw.jtools.Log;
import com.bw.jtools.ui.IconCache;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class JContextMenu
extends JPopupMenu {
    Runnable[] actions_;

    private ActionListener createActionListener(int i) {
        return e -> this.actions_[i].run();
    }

    public JContextMenu(String menu_name, JComponent parent, Object[][] entries, Runnable[] actions) {
        super(menu_name);
        int N = entries.length;
        if (N != actions.length) {
            throw new IllegalArgumentException("Size of 'entries' and 'actions' is not equal");
        }
        this.actions_ = actions;
        for (int i = 0; i < N; ++i) {
            String itemName;
            String string = itemName = entries[i] != null ? String.valueOf(entries[i][0]) : null;
            if (itemName == null) continue;
            if (itemName.equals("---")) {
                this.addSeparator();
                continue;
            }
            if (entries[i].length != 2) {
                throw new IllegalArgumentException("Size of array 'entries[" + i + "]' is not two");
            }
            Icon icon = null;
            Object iconObj = entries[i][1];
            if (iconObj != null) {
                if (iconObj instanceof Icon) {
                    icon = (Icon)iconObj;
                } else if (iconObj instanceof String) {
                    String iconName = (String)iconObj;
                    if (!iconName.isEmpty()) {
                        icon = IconCache.getIcon(iconName);
                    }
                } else {
                    Log.warn("JContextMenu: entries[" + i + "][1] have to be a String of Icon.");
                }
            }
            JMenuItem item = new JMenuItem(itemName, icon);
            item.addActionListener(this.createActionListener(i));
            this.add(item);
        }
        parent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JContextMenu.this.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JContextMenu.this.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }
}

