/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui;

import com.bw.jtools.Log;
import com.bw.jtools.io.IOTool;
import com.bw.jtools.ui.I18N;
import com.bw.jtools.ui.IconCache;
import com.bw.jtools.ui.JLink;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class JExceptionDialog
extends JDialog {
    private JButton SwitchTrace;
    private JButton button_close_;
    private JLabel label_title_;
    private JLink mail_link_;
    private JScrollPane scroller_;
    private JTextArea text_;
    private String shortST;
    private String fullST;
    private boolean showFullST = false;

    public JExceptionDialog(Component parent, Throwable throwed) {
        this(parent, null, null, throwed);
    }

    public JExceptionDialog(Component parent, String title, String message, Throwable throwed) {
        super(SwingUtilities.getWindowAncestor(parent), Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        if (message != null) {
            this.label_title_.setText(message);
        }
        this.setDefaultCloseOperation(2);
        this.setIconImages(IconCache.getAppIconImages());
        String msg = throwed.getMessage();
        if (msg == null || msg.isEmpty()) {
            msg = throwed.getClass().getSimpleName();
        }
        this.setTitle(title == null ? I18N.format("exception.title", msg) : title);
        this.shortST = IOTool.getRestrictedStackTrace(throwed, "", 10);
        this.fullST = IOTool.getRestrictedStackTrace(throwed, "", 2000);
        this.text_.setText(this.shortST);
        try {
            String body = URLEncoder.encode(this.shortST, "UTF-8").replace("+", "%20");
            this.mail_link_.setUri(I18N.getText("exception.reportToUrl") + body);
        }
        catch (UnsupportedEncodingException ex) {
            Log.error("Failed to encode exception e-mail", ex);
        }
    }

    private void initComponents() {
        this.label_title_ = new JLabel();
        this.mail_link_ = new JLink();
        this.button_close_ = new JButton();
        this.scroller_ = new JScrollPane();
        this.text_ = new JTextArea();
        this.SwitchTrace = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setPreferredSize(new Dimension(600, 350));
        this.label_title_.setFont(new Font("Dialog", 1, 14));
        this.label_title_.setText(I18N.getText("exception.info"));
        this.label_title_.setAlignmentY(0.0f);
        this.mail_link_.setToolTipText("mailto:Bernd.Wengenroth@gmx.de");
        this.mail_link_.setAlias(I18N.getText("exception.link.alias"));
        this.mail_link_.setUri("");
        this.button_close_.setText(I18N.getText("button.close"));
        this.button_close_.setToolTipText("");
        this.button_close_.setAlignmentY(0.0f);
        this.button_close_.addActionListener(evt -> this.button_close_ActionPerformed(evt));
        this.text_.setEditable(false);
        this.text_.setColumns(20);
        this.text_.setFont(new Font("SansSerif", 0, 12));
        this.text_.setRows(5);
        this.scroller_.setViewportView(this.text_);
        this.SwitchTrace.setText(I18N.getText("exception.fullTraces"));
        this.SwitchTrace.addActionListener(evt -> this.SwitchTraceActionPerformed(evt));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.SwitchTrace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.button_close_).addGap(18, 18, 18).addComponent(this.mail_link_, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.label_title_, -2, 272, -2).addGap(0, 255, Short.MAX_VALUE)).addComponent(this.scroller_)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.label_title_).addGap(1, 1, 1).addComponent(this.scroller_, -1, 234, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.button_close_).addComponent(this.mail_link_, -2, -1, -2).addComponent(this.SwitchTrace)).addContainerGap()));
        this.pack();
    }

    private void button_close_ActionPerformed(ActionEvent evt) {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void SwitchTraceActionPerformed(ActionEvent evt) {
        this.showFullST = !this.showFullST;
        this.SwitchTrace.setText(this.showFullST ? I18N.getText("exception.shortTraces") : I18N.getText("exception.fullTraces"));
        this.text_.setText(this.showFullST ? this.fullST : this.shortST);
    }
}

