/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui;

import com.bw.jtools.Log;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.JLabel;

public class JLink
extends JLabel {
    URI uri_;
    boolean force_disable_ = true;
    boolean enabled_ = true;
    String alias_;
    String col_ = "blue";
    boolean mouse_entered_ = false;
    static boolean log_desktop_support_missing_ = true;

    public void setUri(String uri) {
        try {
            this.col_ = "blue";
            this.uri_ = new URI(uri);
            this.setToolTipText(uri);
            this.force_disable_ = !Desktop.isDesktopSupported();
        }
        catch (Exception uriEx) {
            this.setToolTipText(null);
            Log.error("Malformed URI " + uri, uriEx);
            this.force_disable_ = true;
        }
        if (this.force_disable_) {
            super.setEnabled(false);
        } else {
            super.setEnabled(this.enabled_);
        }
    }

    public void setAlias(String name) {
        this.alias_ = name;
        this.update_text();
    }

    private void update_text() {
        this.setText(this.mouse_entered_ ? "<HTML><FONT color='" + this.col_ + "'><u>" + this.alias_ + "</u></FONT></HTML>" : "<HTML><FONT color='" + this.col_ + "'>" + this.alias_ + "</FONT></HTML>");
    }

    public JLink(String uri, String text) {
        this();
        this.setUri(uri);
        this.setAlias(text);
    }

    public JLink() {
        if (Desktop.isDesktopSupported()) {
            this.force_disable_ = false;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        Desktop.getDesktop().browse(JLink.this.uri_);
                        JLink.this.col_ = "#660099";
                        JLink.this.update_text();
                    }
                    catch (Exception exp) {
                        Log.error("Failed to open " + JLink.this.uri_, exp);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    JLink.this.mouse_entered_ = true;
                    JLink.this.update_text();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    JLink.this.mouse_entered_ = false;
                    JLink.this.update_text();
                }
            });
        } else {
            this.force_disable_ = true;
            if (log_desktop_support_missing_) {
                log_desktop_support_missing_ = false;
                Log.error("No Desktop Support available, link buttons will be disabled.");
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
        super.setEnabled(enabled && this.force_disable_);
    }
}

