/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui;

import com.bw.jtools.persistence.Store;
import com.bw.jtools.ui.SettingsSwing;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class SettingsUI {
    protected static WindowListener autoFlushPosWindowListerner_ = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            SettingsSwing.storeWindowPosition(e.getWindow());
            Store.flushStorage();
        }
    };
    protected static WindowListener autoFlushWindowListerner_ = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            Store.flushStorage();
        }
    };

    public static Dimension getDimension(String pref_prefix) {
        Dimension dim = new Dimension(0, 0);
        dim.width = Store.getInt(pref_prefix + ".width", 0);
        dim.height = Store.getInt(pref_prefix + ".height", 0);
        return dim;
    }

    public static void loadWindowPosition(Window w) {
        SettingsUI.loadWindowPosition(w, "Window");
    }

    public static void loadWindowPosition(Window w, String pref_prefix) {
        Dimension dim = new Dimension(0, 0);
        dim.width = Store.getInt(pref_prefix + ".width", 0);
        dim.height = Store.getInt(pref_prefix + ".height", 0);
        if (dim.width > 100 && dim.height > 100) {
            w.setSize(dim);
        }
        Point pos = new Point(0, 0);
        pos.x = Store.getInt(pref_prefix + ".x", -1);
        pos.y = Store.getInt(pref_prefix + ".y", -1);
        if (pos.x >= 0 && pos.y >= 0) {
            w.setLocation(pos);
        } else {
            w.setLocationByPlatform(true);
        }
    }

    public static void storeWindowPosition(Window w) {
        SettingsUI.storeWindowPosition(w, "Window");
    }

    public static void storeWindowPosition(Window w, String pref_prefix) {
        Dimension dim = w.getSize();
        Point pos = w.getLocation();
        if (dim.width < 200) {
            dim.width = 100;
        }
        if (dim.height < 100) {
            dim.height = 100;
        }
        Store.setInt(pref_prefix + ".width", dim.width);
        Store.setInt(pref_prefix + ".height", dim.height);
        Store.setInt(pref_prefix + ".x", pos.x);
        Store.setInt(pref_prefix + ".y", pos.y);
    }

    public static void storePositionAndFlushOnClose(Window w) {
        w.removeWindowListener(autoFlushPosWindowListerner_);
        w.addWindowListener(autoFlushPosWindowListerner_);
    }

    public static void flushOnClose(Window w) {
        w.removeWindowListener(autoFlushWindowListerner_);
        w.addWindowListener(autoFlushWindowListerner_);
    }
}

