/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui;

import com.bw.jtools.persistence.Store;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFieldSettingAdapter
implements DocumentListener {
    protected boolean value_set_ = false;
    protected final String pref_;
    protected String last_value_;
    protected JTextField text_;

    public TextFieldSettingAdapter(JTextField f, String pref, String defaultValue) {
        this.text_ = f;
        this.pref_ = pref;
        this.last_value_ = Store.getString(this.pref_, null != defaultValue ? defaultValue : "");
        this.text_.setText(this.last_value_);
        this.value_set_ = true;
        this.text_.getDocument().addDocumentListener(this);
    }

    public TextFieldSettingAdapter(JTextField f, String pref) {
        this(f, pref, null);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textChanged_();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textChanged_();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textChanged_();
    }

    protected void textChanged_() {
        String nv;
        if (this.value_set_ && (nv = this.text_.getText()) != null && !nv.equals(this.last_value_)) {
            this.last_value_ = nv;
            Store.setString(this.pref_, nv);
        }
    }
}

