/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui;

import java.awt.Color;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;

public final class TransferableImage
implements Transferable {
    final Image image_;

    public TransferableImage(Image image) {
        this.image_ = image;
    }

    public TransferableImage(BufferedImage toClipboard, Color backgroundIfAlpha) {
        if (toClipboard != null) {
            if (backgroundIfAlpha == null) {
                backgroundIfAlpha = Color.WHITE;
            }
            if (toClipboard.getColorModel().hasAlpha()) {
                BufferedImage copy = new BufferedImage(toClipboard.getWidth(), toClipboard.getHeight(), 1);
                copy.createGraphics().drawImage(toClipboard, 0, 0, backgroundIfAlpha, null);
                this.image_ = copy;
            } else {
                this.image_ = toClipboard;
            }
        } else {
            this.image_ = null;
        }
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DataFlavor.imageFlavor) && this.image_ != null) {
            return this.image_;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.imageFlavor;
    }
}

