/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui;

import com.bw.jtools.ui.UIToolSwing;
import com.bw.jtools.ui.WaitSplash;
import java.awt.Color;

public final class UITool {
    public static void executeInUIThread(Runnable r) {
        UIToolSwing.executeInUIThread(r);
    }

    public static void showWait(boolean enable) {
        WaitSplash.showWait(enable);
    }

    public static void showWait(boolean enable, String message) {
        WaitSplash.showWait(enable, message);
    }

    public static String escapeHTML(String s) {
        int n = s.length();
        StringBuilder sb = new StringBuilder(n * 2);
        return UITool.escapeHTML(s, 0, n, sb).toString();
    }

    public static StringBuilder escapeHTML(String s, int start, int end, StringBuilder sb) {
        block5: while (start < end) {
            char c = s.charAt(start++);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
            }
            sb.append(c);
        }
        return sb;
    }

    public static Color calculateContrastColor(Color col) {
        float luminance = 0.2126f * (float)col.getRed() + 0.7152f * (float)col.getGreen() + 0.0722f * (float)col.getBlue();
        return luminance < 130.0f ? Color.WHITE : Color.BLACK;
    }
}

