/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui;

import com.bw.jtools.Log;
import com.bw.jtools.ui.DummyIcon;
import com.bw.jtools.ui.I18N;
import com.bw.jtools.ui.IconCache;
import java.awt.Component;
import java.awt.Container;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public final class UIToolSwing {
    private static final Icon dummyIcon = new DummyIcon();

    public static void executeInUIThread(Runnable r) {
        SwingUtilities.invokeLater(r);
    }

    public static void setDoubledBuffered(Container w, boolean enable) {
        for (Component c : w.getComponents()) {
            if (!(c instanceof Container)) continue;
            UIToolSwing.setDoubledBuffered((Container)c, enable);
        }
        if (w instanceof JComponent) {
            ((JComponent)w).setDoubleBuffered(enable);
        }
    }

    public static Icon createButtonIcon(BufferedImage img) {
        return UIToolSwing.createButtonIcon(img, 20);
    }

    public static Icon createButtonIcon(BufferedImage img, int targetHeight) {
        Icon ic;
        if (img != null) {
            try {
                int calcWidth = (int)(0.5 + (double)(targetHeight * img.getWidth()) / (double)img.getHeight());
                ic = new ImageIcon(img.getScaledInstance(calcWidth, targetHeight, 4));
            }
            catch (Throwable t) {
                Log.error(t.getMessage(), t);
                ic = dummyIcon;
            }
        } else {
            ic = null;
        }
        return ic;
    }

    public static JButton createIconButton(String icon) {
        JButton b = new JButton(IconCache.getIcon(icon));
        b.setBorder(null);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setContentAreaFilled(true);
        b.setOpaque(false);
        return b;
    }

    public static JButton createIconRolloverButton(String iconPrefix) {
        JButton b = UIToolSwing.createIconButton(iconPrefix + ".png");
        b.setRolloverEnabled(true);
        Icon roIcon = IconCache.getIcon(iconPrefix + "_ro.png");
        b.setRolloverIcon(roIcon);
        b.setPressedIcon(roIcon);
        return b;
    }

    public static JButton createI18NTextButton(String i18NKey) {
        JButton b = new JButton();
        UIToolSwing.setI18NText(b, i18NKey);
        return b;
    }

    public static void setI18NText(JButton button, String i18NKey) {
        button.setText(I18N.getText(i18NKey));
        String mnemonicKey = i18NKey + ".mnemonic";
        if (I18N.hasText(mnemonicKey)) {
            button.setMnemonic(I18N.getText(mnemonicKey).charAt(0));
        } else if (button.getMnemonic() != 0) {
            button.setMnemonic(0);
        }
    }

    public static JLabel createI18NLabel(String i18NKey) {
        JLabel l = new JLabel();
        UIToolSwing.setI18NText(l, i18NKey);
        return l;
    }

    public static void setI18NText(JLabel label, String i18NKey) {
        label.setText(I18N.getText(i18NKey));
        String mnemonicKey = i18NKey + ".mnemonic";
        if (I18N.hasText(mnemonicKey)) {
            label.setDisplayedMnemonic(I18N.getText(mnemonicKey).charAt(0));
        } else if (label.getDisplayedMnemonic() != 0) {
            label.setDisplayedMnemonic(0);
        }
    }
}

