/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui.data;

import com.bw.jtools.ui.data.DataTableModel;
import com.bw.jtools.ui.data.IDataExporter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class DataCSVExporter
implements IDataExporter {
    public DataCSVExporter() {
        CSVFormat f = CSVFormat.EXCEL;
    }

    @Override
    public void export(File file, DataTableModel model) throws IOException {
        FileWriter writer = new FileWriter(file, false);
        int CN = model.getColumnCount();
        String[] columns = new String[CN];
        for (int ci = 0; ci < CN; ++ci) {
            columns[ci] = model.getColumnName(ci);
        }
        CSVFormat csvFormat = CSVFormat.RFC4180.withHeader(columns);
        CSVPrinter printer = csvFormat.print((Appendable)writer);
        int rowCount = model.getRowCount();
        Object[] row = new Object[CN];
        for (int rIdx = 0; rIdx < rowCount; ++rIdx) {
            for (int ci = 0; ci < CN; ++ci) {
                row[ci] = model.getValueAt(rIdx, ci);
            }
            printer.printRecord(row);
        }
        printer.flush();
        printer.close();
    }
}

