/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui.data;

import com.bw.jtools.persistence.Store;
import com.bw.jtools.ui.data.DataTableModel;
import java.awt.Color;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public final class DataTable
extends JTable {
    protected TableRowSorter<DataTableModel> sorter_;
    protected JViewport viewport_;
    protected JScrollPane scrollpane_;
    private boolean editable_ = false;
    protected String preference_prefix_ = "LogTable.";

    public boolean isEditable() {
        return this.editable_;
    }

    public void setEditable(boolean enable) {
        this.editable_ = enable;
    }

    public DataTable(DataTableModel mdl) {
        this.setDoubleBuffered(true);
        this.setEditable(false);
        this.setModel(mdl);
        this.getSelectionModel().setSelectionMode(0);
        this.setFillsViewportHeight(true);
        this.setAutoscrolls(true);
        this.setAutoResizeMode(3);
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        defaults.put("Table.alternateRowColor", new Color(240, 240, 240));
        defaults.put("Table.background", Color.WHITE);
        TableColumnModel colModel = this.getColumnModel();
        this.sorter_ = new TableRowSorter<DataTableModel>(mdl);
        int CN = colModel.getColumnCount();
        for (int cIdx = 0; cIdx < CN; ++cIdx) {
            this.sorter_.setSortable(cIdx, false);
            colModel.getColumn(cIdx).setCellRenderer(mdl.getCellRenderer(cIdx));
        }
        this.setRowSorter(this.sorter_);
        InputMap imap = this.getInputMap();
        imap.put(KeyStroke.getKeyStroke("ctrl C"), TransferHandler.getCopyAction().getValue("Name"));
    }

    public void setPreferencePrefix(String prefix) {
        this.preference_prefix_ = prefix == null ? "LogTable." : prefix;
    }

    public void loadPreferences() {
        int N = this.getColumnCount();
        TableColumnModel colModel = this.getColumnModel();
        for (int c = 0; c < N; ++c) {
            TableColumn tc = colModel.getColumn(c);
            int colWidth = Store.getInt(this.preference_prefix_ + "col" + (c + 1) + ".width", 80);
            if (colWidth <= 0) continue;
            tc.setPreferredWidth(colWidth);
        }
        this.doLayout();
    }

    public void storePreferences() {
        int N = this.getColumnCount();
        TableColumnModel colModel = this.getColumnModel();
        for (int c = 0; c < N; ++c) {
            int colWidth = colModel.getColumn(c).getWidth();
            Store.setString(this.preference_prefix_ + "col" + (c + 1) + ".width", String.valueOf(colWidth));
        }
    }

    public void setFilters(List<RowFilter<DataTableModel, Integer>> filters) {
        if (filters != null && !filters.isEmpty()) {
            this.sorter_.setRowFilter(RowFilter.andFilter(filters));
        } else {
            this.sorter_.setRowFilter(null);
        }
    }
}

