/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui.data;

import com.bw.jtools.Log;
import com.bw.jtools.io.IOTool;
import com.bw.jtools.persistence.Store;
import com.bw.jtools.ui.I18N;
import com.bw.jtools.ui.IconCache;
import com.bw.jtools.ui.JContextMenu;
import com.bw.jtools.ui.JLink;
import com.bw.jtools.ui.JMenuButton;
import com.bw.jtools.ui.UITool;
import com.bw.jtools.ui.data.DataCSVExporter;
import com.bw.jtools.ui.data.DataTable;
import com.bw.jtools.ui.data.DataTableModel;
import com.bw.jtools.ui.data.IDataExporter;
import com.bw.jtools.ui.data.LogLevelRowFilter;
import com.bw.jtools.ui.data.LoggerDataModel;
import com.bw.jtools.ui.data.StringRowFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class DataTablePanel
extends JPanel {
    boolean auto_scroll_ = false;
    protected String preference_prefix_ = "LogPanel.";
    private boolean scrollListener_invoked_ = false;
    private TableModelListener scrollListener_ = e -> {
        if (e.getType() == 1 && !this.scrollListener_invoked_) {
            this.scrollListener_invoked_ = true;
            UITool.executeInUIThread(() -> {
                this.scrollListener_invoked_ = false;
                this.scroll2End();
            });
        }
    };
    private JCheckBox auto_scroll_check_;
    private JPanel filter_panel_;
    private JCheckBox regexp_check_;
    private JLink regexp_help_;
    private JTextField search_text_;
    private JScrollPane table_scoller_;
    private DataTable view_;
    private JCheckBox debugCheck_;
    private JCheckBox infoCheck_;
    private JCheckBox warningCheck_;
    private JCheckBox errorCheck_;
    private IDataExporter csvExport;
    protected Color error_color_ = new Color(250, 200, 200);

    public void scroll2End() {
        if (this.auto_scroll_ && this.view_ != null && !this.view_.hasFocus()) {
            this.view_.scrollRectToVisible(this.view_.getCellRect(this.view_.getRowCount() - 1, 0, true));
        }
    }

    public void setPreferencePrefix(String prefix) {
        this.preference_prefix_ = prefix == null ? "LogPanel." : prefix;
        if (this.view_ != null) {
            this.view_.setPreferencePrefix(prefix);
        }
    }

    public void loadPreferences() {
        this.auto_scroll_ = Store.getBoolean(this.preference_prefix_ + "autoscroll", false);
        this.auto_scroll_check_.setSelected(this.auto_scroll_);
        this.regexp_check_.setSelected(Store.getBoolean(this.preference_prefix_ + "filter.regexp", false));
        this.search_text_.setText(Store.getString(this.preference_prefix_ + "filter.value", ""));
        if (this.view_ != null) {
            this.view_.loadPreferences();
        }
    }

    public void storePreferences() {
        Store.setBoolean(this.preference_prefix_ + "autoscroll", this.auto_scroll_);
        Store.setBoolean(this.preference_prefix_ + "filter.regexp", this.regexp_check_.isSelected());
        Store.setString(this.preference_prefix_ + "filter.value", this.search_text_.getText());
        if (this.view_ != null) {
            this.view_.storePreferences();
        }
    }

    public DataTablePanel(DataTableModel model) {
        super(new BorderLayout());
        this.initComponents(model);
        this.view_.setPreferencePrefix(this.preference_prefix_);
        this.auto_scroll_ = true;
        this.auto_scroll_check_.setSelected(this.auto_scroll_);
        Object[][] contextMenuEntries = new Object[][]{{I18N.getText("logpanel.clear"), IconCache.getIcon(DataTablePanel.class, "edit-clear.png")}, {I18N.getText("logpanel.export"), IconCache.getIcon(DataTablePanel.class, "media-floppy.png")}};
        try {
            this.csvExport = new DataCSVExporter();
        }
        catch (NoClassDefFoundError t) {
            Log.debug("CSV support not available.", t);
            contextMenuEntries[1] = null;
        }
        JContextMenu menu = new JContextMenu("LogPanel", this.view_, contextMenuEntries, new Runnable[]{() -> ((DataTableModel)this.view_.getModel()).setRowCount(0), () -> this.storeLog()});
        this.updateFilter();
    }

    private void initComponents(DataTableModel model) {
        this.filter_panel_ = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        this.search_text_ = new JTextField();
        this.search_text_.addActionListener(evt -> this.updateFilter());
        gc.gridx = 21;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.anchor = 512;
        this.filter_panel_.add((Component)this.search_text_, gc);
        this.regexp_check_ = new JCheckBox();
        this.regexp_check_.setMnemonic('R');
        this.regexp_check_.setText(I18N.getText("logpanel.regexp.check"));
        this.regexp_check_.addActionListener(evt -> this.updateFilter());
        gc.gridx = -1;
        gc.weightx = 0.0;
        gc.fill = 0;
        this.filter_panel_.add((Component)this.regexp_check_, gc);
        this.regexp_help_ = new JLink();
        this.regexp_help_.setAlias(I18N.getText("logpanel.regexp.help"));
        this.regexp_help_.setUri("https://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html");
        gc.ipadx = 10;
        this.filter_panel_.add((Component)this.regexp_help_, gc);
        gc.ipadx = 0;
        if (model instanceof LoggerDataModel) {
            JPopupMenu levelMenu = new JPopupMenu(I18N.getText("logpanel.levelfilter"));
            this.debugCheck_ = new JCheckBox(I18N.getText("logpanel.debug"));
            levelMenu.add(this.debugCheck_);
            this.infoCheck_ = new JCheckBox(I18N.getText("logpanel.info"));
            levelMenu.add(this.infoCheck_);
            this.warningCheck_ = new JCheckBox(I18N.getText("logpanel.warning"));
            levelMenu.add(this.warningCheck_);
            this.errorCheck_ = new JCheckBox(I18N.getText("logpanel.error"));
            levelMenu.add(this.errorCheck_);
            this.debugCheck_.setSelected(true);
            this.infoCheck_.setSelected(true);
            this.warningCheck_.setSelected(true);
            this.errorCheck_.setSelected(true);
            ItemListener lvlIL = evt -> this.updateFilter();
            this.debugCheck_.addItemListener(lvlIL);
            this.infoCheck_.addItemListener(lvlIL);
            this.warningCheck_.addItemListener(lvlIL);
            this.errorCheck_.addItemListener(lvlIL);
            JMenuButton levelFilterButton = new JMenuButton(I18N.getText("logpanel.levelfilter"), null, levelMenu);
            levelFilterButton.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.filter_panel_.add((Component)levelFilterButton, gc);
        }
        this.auto_scroll_check_ = new JCheckBox(I18N.getText("logpanel.autoscroll"));
        this.auto_scroll_check_.addItemListener(evt -> this.auto_scroll_check_ItemStateChanged(evt));
        this.filter_panel_.add((Component)this.auto_scroll_check_, gc);
        this.add((Component)this.filter_panel_, "North");
        this.view_ = new DataTable(model);
        this.table_scoller_ = new JScrollPane();
        this.table_scoller_.setViewportView(this.view_);
        this.add((Component)this.table_scoller_, "Center");
        this.setPreferredSize(new Dimension(600, 450));
    }

    private void auto_scroll_check_ItemStateChanged(ItemEvent evt) {
        this.auto_scroll_ = this.auto_scroll_check_.isSelected();
        DataTableModel model = (DataTableModel)this.view_.getModel();
        model.removeTableModelListener(this.scrollListener_);
        if (this.auto_scroll_) {
            model.addTableModelListener(this.scrollListener_);
            this.scroll2End();
        }
    }

    public void storeLog() {
        File file;
        if (this.csvExport != null && (file = IOTool.selectFile(this, this.preference_prefix_ + "export", I18N.getText("logpanel.exportcsv.title"), 1, new FileNameExtensionFilter(I18N.getText("logpanel.exportcsv.csvfile"), "csv"))) != null) {
            try {
                this.csvExport.export(file, (LoggerDataModel)this.view_.getModel());
            }
            catch (Exception ex) {
                Log.error(ex.getLocalizedMessage(), ex);
            }
        }
    }

    protected void updateFilter() {
        ArrayList<RowFilter<DataTableModel, Integer>> filter;
        block8: {
            String filter_text = this.search_text_.getText();
            boolean filter_regExp = this.regexp_check_.isSelected();
            filter = new ArrayList<RowFilter<DataTableModel, Integer>>();
            if (!filter_text.isEmpty()) {
                try {
                    if (filter_regExp) {
                        filter.add(RowFilter.regexFilter(filter_text, new int[0]));
                    } else {
                        filter.add(new StringRowFilter(filter_text));
                    }
                    if (this.search_text_ != null && this.error_color_ != null) {
                        this.search_text_.setBackground(this.getBackground());
                    }
                }
                catch (Exception e) {
                    Log.error(e.getMessage());
                    filter.clear();
                    if (this.search_text_ == null || this.error_color_ == null) break block8;
                    this.search_text_.setBackground(this.error_color_);
                }
            }
        }
        if (this.debugCheck_ != null) {
            boolean debug = this.debugCheck_.isSelected();
            boolean info = this.infoCheck_.isSelected();
            boolean warning = this.warningCheck_.isSelected();
            boolean error = this.errorCheck_.isSelected();
            if (!(debug && info && warning && error)) {
                boolean[] levelFlags = new boolean[5];
                levelFlags[1] = error;
                levelFlags[2] = warning;
                levelFlags[3] = info;
                levelFlags[4] = debug;
                filter.add(new LogLevelRowFilter(levelFlags));
            }
        }
        this.view_.setFilters(filter);
    }
}

