/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui.data;

import com.bw.jtools.Log;
import com.bw.jtools.ui.I18N;
import com.bw.jtools.ui.data.DataTableModel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class LoggerDataModel
extends DataTableModel {
    LogTableLogger logger_;
    private DefaultTableCellRenderer defaultCellRenderer_ = new DefaultTableCellRenderer();
    private DateRenderer dateRenderer_ = new DateRenderer();
    private LevelRenderer levelRenderer_ = new LevelRenderer();

    public LoggerDataModel() {
        super(new Object[]{I18N.getText("logtable.column.time"), I18N.getText("logtable.column.level"), I18N.getText("logtable.column.message")}, 0);
        this.logger_ = new LogTableLogger();
        Log.addLogger(this.logger_);
    }

    public Log.LoggerFacade getLogger() {
        return this.logger_;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public TableCellRenderer getCellRenderer(int colIndex) {
        switch (colIndex) {
            case 0: {
                return this.dateRenderer_;
            }
            case 1: {
                return this.levelRenderer_;
            }
        }
        return this.defaultCellRenderer_;
    }

    public void setDateFormat(DateFormat df) {
        if (df != null) {
            this.dateRenderer_.format_ = df;
            this.fireTableDataChanged();
        }
    }

    public static class LevelRenderer
    extends DefaultTableCellRenderer {
        final String DEBUG_LABEL = "DBG";
        final String INFO_LABEL = "INF";
        final String WARN_LABEL = "WRN";
        final String ERROR_LABEL = "ERR";

        @Override
        public void setValue(Object value) {
            if (value instanceof Number) {
                switch (((Number)value).intValue()) {
                    case 4: {
                        this.setText("DBG");
                        break;
                    }
                    case 3: {
                        this.setText("INF");
                        break;
                    }
                    case 1: {
                        this.setText("ERR");
                        break;
                    }
                    case 2: {
                        this.setText("WRN");
                        break;
                    }
                    default: {
                        this.setText(value.toString());
                        break;
                    }
                }
            } else {
                this.setText(value == null ? "" : String.valueOf(value));
            }
        }
    }

    public static class DateRenderer
    extends DefaultTableCellRenderer {
        public DateFormat format_ = new SimpleDateFormat("yy-MM-dd HH:mm:ss.S");

        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : this.format_.format(value));
        }
    }

    protected class LogTableLogger
    extends Log.LoggerFacade {
        Calendar calendar_ = Calendar.getInstance();

        @Override
        public void error(CharSequence msg) {
            LoggerDataModel.this.addRow(new Object[]{this.calendar_.getTime(), 1, msg});
        }

        @Override
        public void warn(CharSequence msg) {
            LoggerDataModel.this.addRow(new Object[]{this.calendar_.getTime(), 2, msg});
        }

        @Override
        public void info(CharSequence msg) {
            LoggerDataModel.this.addRow(new Object[]{this.calendar_.getTime(), 3, msg});
        }

        @Override
        public void debug(CharSequence msg) {
            LoggerDataModel.this.addRow(new Object[]{this.calendar_.getTime(), 4, msg});
        }
    }
}

