/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui.properties;

import com.bw.jtools.ui.I18N;
import com.bw.jtools.ui.JColorIcon;
import com.bw.jtools.ui.properties.PropertyCellRenderer;
import com.bw.jtools.ui.properties.PropertyTable;
import com.bw.jtools.ui.properties.PropertyValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;

public class PropertyCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected final Border empty_border_;
    protected final JComboBox enums_;
    protected final JComboBox<Boolean> booleanNullable_;
    protected final JCheckBox booleanCheckbox_;
    protected final JTextField text_;
    protected final JButton color_;
    protected final JColorIcon colorIcon_;
    protected final PropertyTable table_;
    protected final Font font_ = new Font("SansSerif", 0, 11);
    protected int currentCol;
    protected int currentRow;
    protected PropertyValue currentNode_;
    protected NumberFormat nf_;

    public PropertyCellEditor(PropertyTable table) {
        this.empty_border_ = BorderFactory.createEmptyBorder();
        this.table_ = table;
        this.text_ = new JTextField();
        this.text_.setFont(this.font_);
        this.text_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PropertyCellEditor.this.triggerUpdate();
            }
        });
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                PropertyCellEditor.this.triggerUpdate();
            }
        };
        this.enums_ = new JComboBox();
        this.enums_.setFont(this.font_);
        this.enums_.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.enums_.addItemListener(il);
        this.booleanNullable_ = new JComboBox();
        this.booleanNullable_.addItem(null);
        this.booleanNullable_.addItem(Boolean.TRUE);
        this.booleanNullable_.addItem(Boolean.FALSE);
        this.booleanNullable_.setFont(this.font_);
        this.booleanNullable_.addItemListener(il);
        this.booleanCheckbox_ = new JCheckBox();
        this.booleanCheckbox_.setFont(this.font_);
        this.booleanCheckbox_.addItemListener(il);
        this.colorIcon_ = new JColorIcon(13, 13, null);
        this.color_ = new JButton();
        this.color_.setIcon(this.colorIcon_);
        this.color_.setOpaque(true);
        this.color_.setBorderPainted(false);
        this.color_.setMargin(new Insets(0, 2, 0, 0));
        this.color_.setHorizontalAlignment(2);
        this.color_.setFont(this.font_);
        this.color_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Color newColor = JColorChooser.showDialog(PropertyCellEditor.this.color_, I18N.getText("propertytable.colorchooser.title"), PropertyCellEditor.this.colorIcon_.getColor());
                if (newColor != null) {
                    PropertyCellEditor.this.colorIcon_.setColor(newColor);
                    PropertyCellEditor.this.color_.setText(PropertyCellRenderer.toString(newColor));
                    PropertyCellEditor.this.triggerUpdate();
                }
            }
        });
        this.nf_ = NumberFormat.getInstance();
    }

    @Override
    public Object getCellEditorValue() {
        this.triggerUpdate();
        return null;
    }

    protected void triggerUpdate() {
        if (this.updateCurrentValue()) {
            this.table_.getTableModel().fireTableChanged(this.currentRow, this.currentCol);
        }
    }

    protected boolean updateCurrentValue() {
        if (this.currentNode_ == null) {
            return false;
        }
        Object newUserObject = this.currentNode_.getUserObject();
        if (this.currentNode_.valueClazz_ == String.class) {
            String text = this.text_.getText();
            if (!text.isEmpty() || !this.currentNode_.hasContent()) {
                newUserObject = text;
            }
        } else if (Number.class.isAssignableFrom(this.currentNode_.valueClazz_)) {
            Number nb = this.getNumberValue();
            if (nb != null) {
                Number newNb = this.currentNode_.valueClazz_ == Integer.class ? (Number)nb.intValue() : (Number)(this.currentNode_.valueClazz_ == Double.class ? (Number)nb.doubleValue() : (Number)(this.currentNode_.valueClazz_ == Long.class ? (Number)nb.longValue() : (Number)(this.currentNode_.valueClazz_ == Short.class ? (Number)nb.shortValue() : (Number)(this.currentNode_.valueClazz_ == Byte.class ? (Number)nb.byteValue() : (Number)(this.currentNode_.valueClazz_ == Float.class ? (Number)Float.valueOf(nb.floatValue()) : (Number)nb)))));
                newUserObject = newNb;
            } else if (this.currentNode_.nullable_) {
                newUserObject = null;
            }
        } else if (this.currentNode_.valueClazz_ == Boolean.class) {
            Boolean newBool = this.currentNode_.nullable_ ? (Boolean)this.booleanNullable_.getSelectedItem() : Boolean.valueOf(this.booleanCheckbox_.isSelected());
            newUserObject = newBool;
        } else if (this.currentNode_.valueClazz_.isEnum()) {
            newUserObject = this.enums_.getSelectedItem();
        } else if (Color.class.isAssignableFrom(this.currentNode_.valueClazz_)) {
            newUserObject = this.colorIcon_.getColor();
        }
        boolean changed = false;
        changed = newUserObject == null ? this.currentNode_.getUserObject() != null : !newUserObject.equals(this.currentNode_.getUserObject());
        this.currentNode_.setUserObject(newUserObject);
        return changed;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component comp = null;
        if (this.table_.isCellEditable(row, column)) {
            column = this.table_.convertColumnIndexToModel(column);
            row = this.table_.convertRowIndexToModel(row);
            PropertyValue pv = (PropertyValue)this.table_.getModel().getValueAt(row, -1);
            this.currentNode_ = null;
            this.currentCol = column;
            this.currentRow = row;
            switch (column) {
                case 1: {
                    comp = this.getEditorComponent(pv);
                }
            }
            this.currentNode_ = pv;
        }
        return comp;
    }

    protected Component getEditorComponent(PropertyValue node) {
        boolean useGenericText = false;
        JComponent ed = null;
        if (node.valueClazz_ == String.class) {
            useGenericText = true;
        }
        if (Number.class.isAssignableFrom(node.valueClazz_)) {
            ed = this.text_;
            Number i = (Number)node.getUserObject();
            if (i != null) {
                this.text_.setText((node.nf_ == null ? this.nf_ : node.nf_).format(i));
            } else {
                this.text_.setText("");
            }
        } else if (node.valueClazz_ == Boolean.class) {
            Boolean val = (Boolean)node.getUserObject();
            if (node.nullable_) {
                this.booleanNullable_.setSelectedItem(val);
                ed = this.booleanNullable_;
            } else {
                this.booleanCheckbox_.setSelected(val != null && val != false);
                ed = this.booleanCheckbox_;
            }
        } else if (node.valueClazz_.isEnum()) {
            T[] vals;
            this.enums_.removeAllItems();
            if (node.nullable_) {
                this.enums_.addItem(null);
            }
            for (Object v : vals = node.valueClazz_.getEnumConstants()) {
                this.enums_.addItem(v);
            }
            this.enums_.setSelectedItem(node.getUserObject());
            ed = this.enums_;
        } else if (Color.class.isAssignableFrom(node.valueClazz_)) {
            Color col = (Color)node.getUserObject();
            if (col == null) {
                col = Color.WHITE;
            } else {
                this.color_.setText(PropertyCellRenderer.toString(col));
            }
            this.colorIcon_.setColor(col);
            ed = this.color_;
        } else {
            useGenericText = true;
        }
        if (useGenericText) {
            ed = this.text_;
            if (node.hasContent()) {
                this.text_.setText(String.valueOf(node.getUserObject()));
            } else {
                this.text_.setText("");
            }
        }
        return ed;
    }

    protected Number getNumberValue() {
        try {
            NumberFormat nf = this.nf_;
            if (this.currentNode_ != null && this.currentNode_.nf_ != null) {
                nf = this.currentNode_.nf_;
            }
            Number nb = nf.parse(this.text_.getText());
            return nb;
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

