/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui.properties;

import com.bw.jtools.ui.IconCache;
import com.bw.jtools.ui.JColorIcon;
import com.bw.jtools.ui.properties.PropertyGroup;
import com.bw.jtools.ui.properties.PropertyTable;
import com.bw.jtools.ui.properties.PropertyValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.swing.outline.Outline;

public class PropertyCellRenderer
implements TableCellRenderer {
    protected final Border noBorder_;
    protected final JLabel text_;
    protected final JLabel emptyLabel_;
    protected final Font font_;
    protected final Icon closed;
    protected final Icon open;
    protected final Icon empty;
    protected final JLabel groupHandle_;
    protected final Color groupBackground;
    protected final JCheckBox booleanBox_;
    protected final JLabel color_;
    protected final JColorIcon colorIcon_;
    protected final NumberFormat nf_;
    private final PropertyTable table_;

    public PropertyCellRenderer(PropertyTable table) {
        this.table_ = table;
        this.font_ = new Font("SansSerif", 0, 11);
        this.noBorder_ = BorderFactory.createEmptyBorder(0, 5, 0, 0);
        this.emptyLabel_ = new JLabel("");
        this.emptyLabel_.setOpaque(true);
        this.text_ = new JLabel();
        this.text_.setOpaque(true);
        this.text_.setFont(this.font_);
        this.groupHandle_ = new JLabel();
        this.groupHandle_.setOpaque(true);
        this.groupHandle_.setFont(this.font_);
        this.booleanBox_ = new JCheckBox();
        this.booleanBox_.setOpaque(true);
        this.booleanBox_.setFont(this.font_);
        this.colorIcon_ = new JColorIcon(13, 13, null);
        this.color_ = new JLabel();
        this.color_.setIcon(this.colorIcon_);
        this.color_.setOpaque(true);
        this.color_.setFont(this.font_);
        this.closed = IconCache.getIcon(PropertyTable.class, "group_closed.png");
        this.open = IconCache.getIcon(PropertyTable.class, "group_open.png");
        this.empty = IconCache.getIcon(PropertyTable.class, "group_empty.png");
        this.nf_ = NumberFormat.getInstance();
        this.groupBackground = new Color(200, 200, 200);
    }

    public static String toString(Color col) {
        StringBuilder sb = new StringBuilder(20);
        sb.append(col.getRed()).append(",");
        sb.append(col.getGreen()).append(",");
        sb.append(col.getBlue());
        return sb.toString();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        PropertyTable etable = (PropertyTable)((Object)table);
        column = table.convertColumnIndexToModel(column);
        if (etable instanceof Outline) {
            --column;
        }
        JComponent comp = null;
        Color cellForeground = null;
        Color cellBackground = null;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        boolean group = value instanceof PropertyGroup;
        if (value != null && column == -1) {
            AbstractLayoutCache lc = this.table_.getLayoutCache();
            boolean expanded = lc.isExpanded(lc.getPathForRow(row));
            if (group) {
                this.groupHandle_.setIcon(expanded ? this.open : this.closed);
            } else {
                this.groupHandle_.setIcon(this.empty);
            }
            this.groupHandle_.setText(group ? ((PropertyGroup)node).displayName_ : ((PropertyValue)node).displayName_);
            comp = this.groupHandle_;
        } else if (column == 0 && !group && node != null) {
            PropertyValue propVal = (PropertyValue)node;
            Object val = node.getUserObject();
            if (val instanceof Number) {
                this.text_.setText((propVal.nf_ == null ? this.nf_ : propVal.nf_).format(val));
                comp = this.text_;
            } else if (val instanceof Color) {
                Color c = (Color)val;
                this.colorIcon_.setColor(c);
                this.color_.setText(PropertyCellRenderer.toString(c));
                comp = this.color_;
            } else if (propVal.valueClazz_ == Boolean.class && !propVal.nullable_) {
                this.booleanBox_.setSelected(val != null && (Boolean)val != false);
                comp = this.booleanBox_;
            } else {
                String sval = val != null ? String.valueOf(val) : "";
                this.text_.setText(sval);
                comp = this.text_;
            }
        }
        if (comp == null) {
            comp = this.emptyLabel_;
        }
        if (cellForeground == null) {
            if (isSelected) {
                cellForeground = UIManager.getColor("Table.selectionForeground");
                cellBackground = UIManager.getColor("Table.selectionBackground");
            } else {
                cellBackground = group ? this.groupBackground : UIManager.getColor("Table.background");
                cellForeground = UIManager.getColor("Table.foreground");
            }
        }
        comp.setForeground(cellForeground);
        comp.setBackground(cellBackground);
        if (column == 0) {
            comp.setBorder(this.noBorder_);
        } else {
            comp.setBorder(null);
        }
        return comp;
    }
}

