/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui.properties;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class PropertyColumnResizeAdapter
extends MouseInputAdapter {
    private int mouseXOffset;
    private JTable table;
    private JTableHeader header;
    public static Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    public static Cursor normalCursor;
    private boolean resizeCursorSet = false;
    private TableColumn resizingColumn;

    public PropertyColumnResizeAdapter(JTable table) {
        this.table = table;
        this.header = table.getTableHeader();
        table.addMouseListener(this);
        table.addMouseMotionListener(this);
    }

    private TableColumn getResizingColumn(Point p) {
        return this.getResizingColumn(p, this.table.columnAtPoint(p));
    }

    private TableColumn getResizingColumn(Point p, int column) {
        int columnIndex;
        if (column == -1) {
            return null;
        }
        Rectangle r = this.table.getCellRect(0, column, true);
        if (Math.abs(p.x - r.x) > 3 && Math.abs(p.x - (r.x + r.width)) > 3) {
            return null;
        }
        int midPoint = r.x + r.width / 2;
        if (this.table.getComponentOrientation().isLeftToRight()) {
            columnIndex = p.x < midPoint ? column - 1 : column;
        } else {
            int n = columnIndex = p.x < midPoint ? column : column - 1;
        }
        if (columnIndex == -1) {
            return null;
        }
        return this.table.getColumnModel().getColumn(columnIndex);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        int index = this.table.columnAtPoint(p);
        if (index != -1) {
            this.resizingColumn = this.getResizingColumn(p, index);
            this.header.setResizingColumn(this.resizingColumn);
            if (this.resizingColumn != null) {
                this.mouseXOffset = this.table.getComponentOrientation().isLeftToRight() ? p.x - this.resizingColumn.getWidth() : p.x + this.resizingColumn.getWidth();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.getResizingColumn(e.getPoint()) != null) {
            if (!this.resizeCursorSet) {
                this.resizeCursorSet = true;
                normalCursor = this.table.getCursor();
                this.table.setCursor(resizeCursor);
            }
        } else if (this.resizeCursorSet) {
            this.resizeCursorSet = false;
            this.table.setCursor(normalCursor);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int mouseX = e.getX();
        boolean headerLeftToRight = this.table.getComponentOrientation().isLeftToRight();
        if (this.resizingColumn != null) {
            int oldWidth = this.resizingColumn.getWidth();
            int newWidth = headerLeftToRight ? mouseX - this.mouseXOffset : this.mouseXOffset - mouseX;
            this.resizingColumn.setWidth(newWidth);
            Container container = this.table.getParent().getParent();
            if (container == null || !(container instanceof JScrollPane)) {
                return;
            }
            if (!container.getComponentOrientation().isLeftToRight() && !this.table.getComponentOrientation().isLeftToRight()) {
                JViewport viewport = ((JScrollPane)container).getViewport();
                int viewportWidth = viewport.getWidth();
                int diff = newWidth - oldWidth;
                int newTableWidth = this.table.getWidth() + diff;
                Dimension tableSize = this.table.getSize();
                tableSize.width += diff;
                this.table.setSize(tableSize);
                if (newTableWidth >= viewportWidth && this.table.getAutoResizeMode() == 0) {
                    Point p = viewport.getViewPosition();
                    p.x = Math.max(0, Math.min(newTableWidth - viewportWidth, p.x + diff));
                    viewport.setViewPosition(p);
                    this.mouseXOffset += diff;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.resizingColumn = null;
        this.header.setResizingColumn(null);
    }
}

