/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui.properties;

import com.bw.jtools.ui.properties.PropertyCellEditor;
import com.bw.jtools.ui.properties.PropertyCellRenderer;
import com.bw.jtools.ui.properties.PropertyColumnResizeAdapter;
import com.bw.jtools.ui.properties.PropertyGroup;
import com.bw.jtools.ui.properties.PropertyOutlineModel;
import com.bw.jtools.ui.properties.PropertyTableDataProvider;
import com.bw.jtools.ui.properties.PropertyTableModel;
import com.bw.jtools.ui.properties.PropertyValue;
import com.bw.jtools.ui.properties.ProperyTableHeader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.Outline;

public final class PropertyTable
extends Outline {
    public static final int COLUMN_VALUE = 0;
    public static final int COLUMN_COUNT = 1;
    private boolean editable_;

    public boolean isEditable() {
        return this.editable_;
    }

    public void setEditable(boolean editable) {
        this.editable_ = editable;
    }

    public PropertyValue getSelectedNode() {
        Object nodeValue;
        int row = this.getSelectedRow();
        if (row >= 0 && (nodeValue = this.getValueAt(row, 0)) instanceof PropertyValue) {
            return (PropertyValue)nodeValue;
        }
        return null;
    }

    public DefaultTreeModel getTreeModel() {
        return ((PropertyOutlineModel)this.getOutlineModel()).getTreeModel();
    }

    public PropertyTableModel getTableModel() {
        return ((PropertyOutlineModel)this.getOutlineModel()).getTableModel();
    }

    public void expandAll() {
        PropertyGroup root = (PropertyGroup)this.getTreeModel().getRoot();
        if (root != null) {
            int N = root.getChildCount();
            for (int i = 0; i < N; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
                if (!(node instanceof PropertyGroup)) continue;
                this.expandPath(new TreePath(node.getPath()));
            }
        }
    }

    protected JTableHeader createDefaultTableHeader() {
        return new ProperyTableHeader(this.columnModel);
    }

    public PropertyTable() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        defaults.put("Table.background", Color.WHITE);
        this.editable_ = true;
        new PropertyColumnResizeAdapter((JTable)((Object)this));
        this.setRootVisible(false);
        this.setRenderDataProvider(new PropertyTableDataProvider());
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setSurrendersFocusOnKeystroke(true);
        this.setFont(new Font("Verdana", 0, 10));
        this.setShowGrid(true);
        this.setGridColor(new Color(200, 200, 200));
        this.setIntercellSpacing(new Dimension(1, 1));
        this.setFillsViewportHeight(true);
        this.setAutoscrolls(true);
        PropertyOutlineModel mdl = PropertyOutlineModel.createOutlineModel();
        mdl.getTableModel().setEditable(this.editable_);
        this.setModel((TableModel)((Object)mdl));
        this.getSelectionModel().setSelectionMode(0);
        TableColumnModel colModel = this.getColumnModel();
        PropertyCellRenderer renderer = new PropertyCellRenderer(this);
        PropertyCellEditor editor = new PropertyCellEditor(this);
        TableColumn column = colModel.getColumn(0);
        column.setCellRenderer(renderer);
        column.setCellEditor(editor);
        column = colModel.getColumn(1);
        column.setCellRenderer(renderer);
        column.setCellEditor(editor);
        InputMap imap = this.getInputMap(0);
        imap.put(KeyStroke.getKeyStroke("ctrl C"), TransferHandler.getCopyAction().getValue("Name"));
        imap.put(KeyStroke.getKeyStroke("ctrl V"), TransferHandler.getPasteAction().getValue("Name"));
        imap.put(KeyStroke.getKeyStroke(113, 0), "editMe");
        imap.put(KeyStroke.getKeyStroke(10, 0), "editMe");
        imap.put(KeyStroke.getKeyStroke(32, 0), "editMe");
        ActionMap am = this.getActionMap();
        AbstractAction editAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c;
                int row = PropertyTable.this.getSelectedRow();
                int col = PropertyTable.this.getSelectedColumn();
                if (!PropertyTable.this.isEditing() && PropertyTable.this.editCellAt(row, col) && (c = PropertyTable.this.getEditorComponent()) instanceof JButton) {
                    ((JButton)c).doClick(100);
                }
            }
        };
        am.put("editMe", editAction);
    }

    public void updateUI() {
        super.updateUI();
    }
}

