/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.ui.properties;

import com.bw.jtools.ui.properties.PropertyGroup;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.swing.outline.OutlineModel;

public class PropertyTableModel
implements TableModel {
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private OutlineModel outlineModel;
    private boolean editable_ = true;

    public void setEditable(boolean enable) {
        this.editable_ = enable;
    }

    public void setOutlineModel(OutlineModel outline) {
        this.outlineModel = outline;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return "";
    }

    @Override
    public int getRowCount() {
        return -1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getNodeForRow(rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        DefaultMutableTreeNode node = this.getNodeForRow(rowIndex);
        if (node instanceof PropertyGroup) {
            return false;
        }
        return this.editable_;
    }

    @Override
    public synchronized void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public synchronized void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(TableModelEvent e) {
        TableModelListener[] l;
        PropertyTableModel propertyTableModel = this;
        synchronized (propertyTableModel) {
            l = new TableModelListener[this.listeners.size()];
            l = this.listeners.toArray(l);
        }
        for (int i = 0; i < l.length; ++i) {
            l[i].tableChanged(e);
        }
    }

    public void fireTableChanged(int rowIndex, int columnIndex) {
        TableModelEvent e = new TableModelEvent(this, rowIndex, rowIndex, columnIndex);
        this.fire(e);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    private DefaultMutableTreeNode getNodeForRow(int row) {
        return (DefaultMutableTreeNode)this.outlineModel.getValueAt(row, 0);
    }
}

