/*
 * Decompiled with CFR 0.152.
 */
package io.github.c_a_services.log4j2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.PublicKey;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="DailyFileSftpAppender", category="Core", elementType="appender", printObject=true)
public class DailyFileSftpAppender
extends AbstractAppender {
    private String userName;
    private String privateKeyResource;
    private String passPhrase;
    private String filePattern;
    private String hostName;
    private String pathName;
    private String publicKeyResource;
    private transient SFTPClient sftpClient;
    private transient SSHClient ssh;
    private RolloverStrategy strategy;
    private transient Thread writerThread;
    private LinkedList<String> pendingStrings = new LinkedList();
    private String currentFileName;

    protected DailyFileSftpAppender(String aName, Filter aFilter, Layout<? extends Serializable> aLayout, RolloverStrategy aStrategy, boolean ignoreExceptions, String aUserName, String aPublicKeyResource, String aPrivateKeyResource, String aFilePattern, String aHostName, String aPathName, String aPassPhrase) {
        super(aName, aFilter, aLayout, ignoreExceptions);
        this.userName = aUserName;
        this.publicKeyResource = aPublicKeyResource;
        this.privateKeyResource = aPrivateKeyResource;
        this.filePattern = aFilePattern;
        this.hostName = aHostName;
        this.pathName = aPathName;
        this.passPhrase = aPassPhrase;
        this.strategy = aStrategy;
    }

    @PluginFactory
    public static DailyFileSftpAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginElement(value="Layout") Layout<? extends Serializable> aLayout, @PluginElement(value="Filters") Filter filter, @PluginElement(value="Strategy") RolloverStrategy strategy, @PluginAttribute(value="userName") String aUserName, @PluginAttribute(value="publicKeyResource") String aPublicKeyResource, @PluginAttribute(value="privateKeyResource") String aPrivateKeyResource, @PluginAttribute(value="passPhrase") String aPassPhrase, @PluginAttribute(value="filePattern") String aFilePattern, @PluginAttribute(value="hostName") String aHostName, @PluginAttribute(value="pathName") String aPathName) {
        if (name == null) {
            LOGGER.error("No name provided for StubAppender");
            return null;
        }
        Layout<? extends Serializable> tempLayout = aLayout == null ? PatternLayout.createDefaultLayout() : aLayout;
        return new DailyFileSftpAppender(name, filter, tempLayout, strategy, ignoreExceptions, aUserName, aPublicKeyResource, aPrivateKeyResource, aFilePattern, aHostName, aPathName, aPassPhrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushPending() {
        StringBuilder tempString;
        Object object = this.pendingStrings;
        synchronized (object) {
            if (this.pendingStrings.isEmpty()) {
                return;
            }
            tempString = new StringBuilder(16384);
            while (!this.pendingStrings.isEmpty()) {
                tempString.append(this.pendingStrings.removeFirst());
                if (tempString.length() <= 16384) continue;
            }
        }
        object = this;
        synchronized (object) {
            try {
                RemoteFile tempFile = this.getRemoteFile(this.currentFileName);
                byte[] tempBytes = tempString.toString().getBytes("UTF-8");
                tempFile.write(tempFile.length(), tempBytes, 0, tempBytes.length);
                tempFile.close();
            }
            catch (IOException e) {
                this.logError("Retry", e);
                this.sftpClient = null;
                this.ssh = null;
                try {
                    RemoteFile tempFile = this.getRemoteFile(this.currentFileName);
                    byte[] tempBytes = tempString.toString().getBytes("UTF-8");
                    tempFile.write(tempFile.length(), tempBytes, 0, tempBytes.length);
                    tempFile.close();
                }
                catch (IOException e2) {
                    this.logInfo(tempString.toString());
                    this.logError("Failure", e2);
                    throw new RuntimeException(e2);
                }
            }
        }
    }

    public void stop() {
        this.shutdown();
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent aEvent) {
        this.initializeWriterThread();
        Serializable tempString = this.getLayout().toSerializable(aEvent);
        LocalDate tempLocalDateTime = Instant.ofEpochMilli(aEvent.getTimeMillis()).atZone(ZoneId.systemDefault()).toLocalDate();
        String tempFileName = tempLocalDateTime + "-" + this.filePattern;
        LinkedList<String> linkedList = this.pendingStrings;
        synchronized (linkedList) {
            if (!tempFileName.equals(this.currentFileName)) {
                this.logDebug("Rollover");
                if (!this.pendingStrings.isEmpty()) {
                    this.pendingStrings.notifyAll();
                    try {
                        this.pendingStrings.wait(20000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Error", e);
                    }
                }
                if (!this.pendingStrings.isEmpty()) {
                    this.logWarn("Some " + this.pendingStrings.size() + " log-entries could not be stored, will be stored in next days file.");
                }
                this.rollover();
                this.currentFileName = tempFileName;
            }
            this.pendingStrings.add(tempString.toString());
            this.pendingStrings.notifyAll();
        }
    }

    private void rollover() {
        int tempMaxIndex;
        int tempMaxDays = 20;
        if (this.strategy instanceof DefaultRolloverStrategy && (tempMaxIndex = ((DefaultRolloverStrategy)this.strategy).getMaxIndex()) > 0) {
            tempMaxDays = tempMaxIndex;
        }
        if (this.sftpClient == null) {
            this.logDebug("Skip rollover as no sftpClient");
        } else {
            final HashSet<LocalDate> tempValidDates = new HashSet<LocalDate>();
            LocalDate tempLocalDate = LocalDate.now();
            for (int i = 0; i < tempMaxDays; ++i) {
                tempValidDates.add(tempLocalDate);
                tempLocalDate = tempLocalDate.minus(1L, ChronoUnit.DAYS);
            }
            try {
                List tempToBeDeleted = this.sftpClient.ls(this.pathName, new RemoteResourceFilter(){

                    public boolean accept(RemoteResourceInfo aResource) {
                        String tempName = aResource.getName();
                        if (tempName.length() >= 10) {
                            try {
                                LocalDate tempFileDate = LocalDate.parse(tempName.substring(0, 10));
                                if (!tempValidDates.contains(tempFileDate)) {
                                    return true;
                                }
                            }
                            catch (DateTimeParseException e) {
                                DailyFileSftpAppender.this.logError("Ignore, not a date file", e);
                            }
                        }
                        return false;
                    }
                });
                for (RemoteResourceInfo tempRemoteResource : tempToBeDeleted) {
                    String tempPath = tempRemoteResource.getPath();
                    this.logInfo("Delete " + tempPath);
                    this.sftpClient.rm(tempPath);
                }
            }
            catch (IOException e) {
                this.logError("Ignore", e);
            }
        }
    }

    private void initializeWriterThread() {
        if (this.writerThread == null) {
            this.writerThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    this.setName("DailyFileSftpAppenderWriter-" + this.getName());
                    try {
                        while (true) {
                            LinkedList linkedList = DailyFileSftpAppender.this.pendingStrings;
                            synchronized (linkedList) {
                                if (DailyFileSftpAppender.this.pendingStrings.isEmpty()) {
                                    DailyFileSftpAppender.this.pendingStrings.wait();
                                }
                            }
                            DailyFileSftpAppender.this.flushPending();
                        }
                    }
                    catch (InterruptedException e) {
                        DailyFileSftpAppender.this.flushPending();
                        return;
                    }
                }
            };
            this.writerThread.setDaemon(false);
            this.writerThread.start();
        }
    }

    private RemoteFile getRemoteFile(String aFileName) throws IOException {
        if (this.sftpClient == null) {
            if (this.ssh == null) {
                this.ssh = new SSHClient();
                this.ssh.addHostKeyVerifier(new HostKeyVerifier(){

                    public boolean verify(String aHostname, int aPort, PublicKey aKey) {
                        return aHostname.equals(DailyFileSftpAppender.this.hostName);
                    }
                });
                this.ssh.connect(this.hostName);
                KeyProvider tempKey = this.loadKey(this.ssh);
                this.ssh.authPublickey(this.userName, new KeyProvider[]{tempKey});
            }
            try {
                this.sftpClient = this.ssh.newSFTPClient();
            }
            catch (IOException | RuntimeException e) {
                this.logError("Error", e);
                throw new RuntimeException(e);
            }
        }
        HashSet<OpenMode> tempOpenModes = new HashSet<OpenMode>();
        tempOpenModes.add(OpenMode.WRITE);
        tempOpenModes.add(OpenMode.APPEND);
        tempOpenModes.add(OpenMode.CREAT);
        RemoteFile tempFile = this.sftpClient.open(this.pathName + aFileName, tempOpenModes);
        return tempFile;
    }

    private KeyProvider loadKey(SSHClient aSsh) throws IOException {
        File tempTempPrivateFile = this.createTempKeyFile(this.privateKeyResource, null);
        String tempPublicKeyExtension = this.publicKeyResource.substring(this.privateKeyResource.length());
        File tempTempPubFile = this.createTempKeyFile(this.publicKeyResource, new File(tempTempPrivateFile.getAbsolutePath() + tempPublicKeyExtension));
        if (LOGGER.isDebugEnabled()) {
            this.logDebug("tempTempPub=" + tempTempPubFile + " for " + this.publicKeyResource);
        }
        KeyProvider tempKey = this.passPhrase == null ? aSsh.loadKeys(tempTempPrivateFile.getAbsolutePath()) : aSsh.loadKeys(tempTempPrivateFile.getAbsolutePath(), this.passPhrase);
        tempTempPubFile.delete();
        if (LOGGER.isDebugEnabled()) {
            this.logDebug("Loaded " + tempKey + " for " + this.privateKeyResource);
        }
        return tempKey;
    }

    private void logDebug(String aString) {
        LOGGER.debug("DailyFileSftpAppender:" + aString);
    }

    private void logInfo(String aString) {
        LOGGER.info("DailyFileSftpAppender:" + aString);
    }

    private void logWarn(String aString) {
        LOGGER.warn("DailyFileSftpAppender:" + aString);
    }

    private File createTempKeyFile(String aResource, File aTargetFile) throws IOException {
        File tempFile = aTargetFile;
        if (tempFile == null) {
            tempFile = File.createTempFile("DailyFileSftpAppender", aResource.replace('/', '_'));
        }
        tempFile.deleteOnExit();
        InputStream tempIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(aResource);
        if (tempIn == null) {
            throw new IllegalArgumentException(this.privateKeyResource + " not found.");
        }
        try (FileOutputStream tempOut = new FileOutputStream(tempFile);){
            byte[] tempBuff = new byte[16384];
            int tempRead = tempIn.read(tempBuff);
            while (tempRead > 0) {
                tempOut.write(tempBuff, 0, tempRead);
                tempRead = tempIn.read(tempBuff);
            }
            tempIn.close();
        }
        return tempFile;
    }

    private void logError(String aString, Exception aE) {
        LOGGER.error("DailyFileSftpAppender:" + aString, (Throwable)aE);
    }

    private void shutdown() {
        if (this.writerThread != null) {
            this.writerThread.interrupt();
            this.writerThread = null;
        }
        if (this.sftpClient != null) {
            try {
                this.sftpClient.close();
            }
            catch (IOException e) {
                this.logError("Ignore", e);
            }
        }
        this.sftpClient = null;
        if (this.ssh != null) {
            try {
                this.ssh.close();
            }
            catch (IOException e) {
                this.logError("Ignore", e);
            }
        }
        this.ssh = null;
    }
}

