/*
 * Decompiled with CFR 0.152.
 */
package io.github.c_a_services.mule4.jar;

import io.github.c_a_services.mule4.jar.impl.ZipCompressHelper;
import io.github.c_a_services.mule4.jar.impl.ZipContentReplacer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="jar-refill")
public class MulestacMavenJarRefillPlugin
extends AbstractMojo {
    @Parameter(property="sourceFile", required=true, defaultValue="${basedir}/target/${project.artifactId}-${project.version}-mule-application.jar")
    private File sourceFile;
    @Parameter(property="temporaryFile", required=true, defaultValue="${basedir}/target/${project.artifactId}-${project.version}-mule-application-temp.jar")
    private File temporaryFile;
    @Parameter(property="keepTemporaryFile", required=true, defaultValue="false")
    private boolean keepTemporaryFile;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException {
        Log tempLog = this.getLog();
        tempLog.info((CharSequence)"refill...");
        tempLog.info((CharSequence)("sourceFile=" + this.getSourceFile()));
        tempLog.info((CharSequence)("destinationFile=" + this.getTemporaryFile()));
        tempLog.info((CharSequence)("keepTemporaryFile=" + this.isKeepTemporaryFile()));
        tempLog.info((CharSequence)("dependencyFolder=" + this.getBasedir()));
        try {
            this.doExecute();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error", (Exception)e);
        }
        tempLog.info((CharSequence)"compress finished...");
    }

    protected String getBasedir() {
        return this.localRepository.getBasedir();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doExecute() throws IOException, MojoExecutionException {
        ZipCompressHelper tempZipCompressHelper = new ZipCompressHelper(this.getLog());
        tempZipCompressHelper.setMavenLocalRepositoryFolder(this.getBasedir());
        ZipContentReplacer tempReplacer = new ZipContentReplacer(){

            @Override
            public InputStream replace(String aNameWithoutRepositoryPrefix, File aLocalFile, InputStream aIn) throws IOException, MojoExecutionException {
                byte[] tempProbe;
                byte[] tempReplacedBytes = ZipCompressHelper.getReplacedBytes();
                int tempExpectedLength = tempReplacedBytes.length;
                PushbackInputStream tempPushbackInputStream = new PushbackInputStream(aIn, tempExpectedLength);
                int tempRead = tempPushbackInputStream.read(tempProbe = new byte[tempExpectedLength]);
                if (tempRead > 0) {
                    tempPushbackInputStream.unread(tempProbe, 0, tempRead);
                }
                if (tempRead == tempExpectedLength && Arrays.equals(tempProbe, tempReplacedBytes)) {
                    if (!aLocalFile.exists()) {
                        MulestacMavenJarRefillPlugin.this.downloadArtifact(aNameWithoutRepositoryPrefix, aLocalFile);
                    }
                    MulestacMavenJarRefillPlugin.this.getLog().info((CharSequence)("Refill content:" + aNameWithoutRepositoryPrefix + " with " + aLocalFile.length() + " bytes."));
                    return new FileInputStream(aLocalFile);
                }
                MulestacMavenJarRefillPlugin.this.getLog().info((CharSequence)("Keep content of " + aNameWithoutRepositoryPrefix));
                return tempPushbackInputStream;
            }

            @Override
            public boolean skipEntry(String aName) {
                return false;
            }
        };
        File tempSourceFile = this.getSourceFile();
        File tempDestinationFile = this.getTemporaryFile();
        tempZipCompressHelper.copyZip(tempSourceFile, tempDestinationFile, tempReplacer);
        this.getLog().info((CharSequence)(tempSourceFile.getName() + " Size=" + tempSourceFile.length()));
        this.getLog().info((CharSequence)(tempDestinationFile.getName() + " Size=" + tempDestinationFile.length()));
        if (this.isKeepTemporaryFile()) {
            FileUtils.copyFile((File)tempDestinationFile, (File)tempSourceFile);
            this.getLog().info((CharSequence)("Copied " + tempDestinationFile + " to " + tempSourceFile));
            return;
        } else {
            if (!tempSourceFile.delete()) throw new IOException("Could not delete " + tempSourceFile);
            if (!tempDestinationFile.renameTo(tempSourceFile)) throw new IOException("Could not rename " + tempDestinationFile + " to " + tempSourceFile);
            this.getLog().info((CharSequence)("Renamed " + tempDestinationFile + " to " + tempSourceFile));
        }
    }

    protected void downloadArtifact(String aNameWithoutRepositoryPrefix, File aLocalFile) throws MojoExecutionException {
        String tempArtifact = this.guessGAV(aNameWithoutRepositoryPrefix);
        try {
            Plugin tempDependencyPlugin = MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"));
            tempDependencyPlugin = this.getVersionOfPlugin(tempDependencyPlugin);
            this.getLog().info((CharSequence)("Manually download " + tempArtifact + " via " + tempDependencyPlugin + ":" + tempDependencyPlugin.getVersion() + " ... "));
            MojoExecutor.executeMojo((Plugin)tempDependencyPlugin, (String)MojoExecutor.goal((String)"get"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifact"), (String)tempArtifact), MojoExecutor.element((String)MojoExecutor.name((String)"transitive"), (String)"false")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException("Error getting " + tempArtifact + " for " + aNameWithoutRepositoryPrefix + " to " + aLocalFile.getAbsolutePath(), e);
        }
        if (!aLocalFile.exists()) {
            throw new MojoExecutionException("Cannot replace " + aNameWithoutRepositoryPrefix + " as file " + aLocalFile.getAbsolutePath() + " is missing and could not be downloaded.");
        }
        this.getLog().info((CharSequence)("Downloaded " + aLocalFile.length() + " bytes of " + aLocalFile.getName()));
    }

    private Plugin getVersionOfPlugin(Plugin aDependencyPlugin) {
        String tempVersionOfPlugin = this.getVersionOfPlugin(this.mavenProject, aDependencyPlugin);
        if (tempVersionOfPlugin != null) {
            this.getLog().debug((CharSequence)("Found version " + tempVersionOfPlugin + " for " + aDependencyPlugin));
            aDependencyPlugin.setVersion(tempVersionOfPlugin);
        }
        return aDependencyPlugin;
    }

    private String getVersionOfPlugin(MavenProject aMavenProject, Plugin aDependencyPlugin) {
        MavenProject tempParent;
        List tempBuildPlugins;
        PluginManagement pm = aMavenProject.getPluginManagement();
        if (pm != null) {
            for (Plugin p : pm.getPlugins()) {
                if (!aDependencyPlugin.getGroupId().equals(p.getGroupId()) || !aDependencyPlugin.getArtifactId().equals(p.getArtifactId())) continue;
                String tempVersion = p.getVersion();
                this.getLog().debug((CharSequence)("Found " + tempVersion + " in PluginManagement " + aMavenProject));
                return tempVersion;
            }
        }
        if ((tempBuildPlugins = aMavenProject.getBuildPlugins()) != null) {
            for (Plugin p : tempBuildPlugins) {
                if (!aDependencyPlugin.getGroupId().equals(p.getGroupId()) || !aDependencyPlugin.getArtifactId().equals(p.getArtifactId())) continue;
                String tempVersion = p.getVersion();
                this.getLog().debug((CharSequence)("Found " + tempVersion + " in BuildPlugins " + aMavenProject));
                return tempVersion;
            }
        }
        if ((tempParent = aMavenProject.getParent()) != null) {
            return this.getVersionOfPlugin(tempParent, aDependencyPlugin);
        }
        return null;
    }

    String guessGAV(String aNameWithoutRepositoryPrefix) {
        try {
            return this.guessGAVimpl(aNameWithoutRepositoryPrefix);
        }
        catch (RuntimeException e) {
            String tempMessage = "Error getting GAV for " + aNameWithoutRepositoryPrefix;
            this.getLog().error((CharSequence)tempMessage, (Throwable)e);
            throw new RuntimeException(tempMessage, e);
        }
    }

    private String guessGAVimpl(String aNameWithoutRepositoryPrefix) {
        int tempLast = aNameWithoutRepositoryPrefix.lastIndexOf(47);
        String tempPath = aNameWithoutRepositoryPrefix.substring(0, tempLast);
        String tempFileName = aNameWithoutRepositoryPrefix.substring(tempLast + 1);
        int tempVersionPos = tempPath.lastIndexOf(47);
        int tempArtifactFolderPos = tempPath.substring(0, tempVersionPos).lastIndexOf(47);
        String tempGroupId = tempPath.substring(0, tempArtifactFolderPos).replace('/', '.');
        String tempVersion = tempPath.substring(tempVersionPos + 1);
        int tempVersionInFileNamePos = tempFileName.indexOf("-" + tempVersion);
        if (tempVersionInFileNamePos == -1) {
            throw new IllegalArgumentException("Did not find '-" + tempVersion + "' in " + tempFileName);
        }
        String tempArtifactId = tempFileName.substring(0, tempVersionInFileNamePos);
        int tempFileNameDotPos = tempFileName.lastIndexOf(46);
        int tempClassifierPos = tempVersionInFileNamePos + tempVersion.length() + 2;
        String tempClassifier = tempClassifierPos < tempFileNameDotPos ? tempFileName.substring(tempClassifierPos, tempFileNameDotPos) : null;
        String tempPackaging = tempFileName.substring(tempFileNameDotPos + 1);
        String tempArtifact = tempGroupId + ':' + tempArtifactId + ':' + tempVersion + ':' + tempPackaging;
        if (tempClassifier != null && tempClassifier.length() > 0) {
            tempArtifact = tempArtifact + ':' + tempClassifier;
        }
        return tempArtifact;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File aSourceFile) {
        this.sourceFile = aSourceFile;
    }

    public File getTemporaryFile() {
        return this.temporaryFile;
    }

    public void setTemporaryFile(File aDestinationFile) {
        this.temporaryFile = aDestinationFile;
    }

    public boolean isKeepTemporaryFile() {
        return this.keepTemporaryFile;
    }

    public void setKeepTemporaryFile(boolean aKeepTemporaryFile) {
        this.keepTemporaryFile = aKeepTemporaryFile;
    }
}

