/*
 * Decompiled with CFR 0.152.
 */
package io.github.c_a_services.mule4.jar.impl;

import io.github.c_a_services.mule4.jar.impl.ZipContentReplacer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class ZipCompressHelper {
    private Log log;
    private static final byte[] REPLACED_BYTES = "REPLACED".getBytes();
    private String mavenLocalRepositoryFolder;

    public ZipCompressHelper(Log aLog) {
        this.log = aLog;
    }

    private boolean isReplaced(String aName) {
        return aName.startsWith("repository/") && aName.endsWith(".jar") && aName.indexOf("SNAPSHOT") == -1;
    }

    public void copyZip(File aSourceFile, File aDestinationFile, ZipContentReplacer aReplacer) throws IOException, MojoExecutionException {
        File tempDestinationDir = aDestinationFile.getParentFile();
        if (!tempDestinationDir.exists() && !tempDestinationDir.mkdirs()) {
            throw new IOException("Cannot create directory " + tempDestinationDir + " for file " + aDestinationFile.getAbsolutePath());
        }
        byte[] tempBuff = new byte[0x100000];
        try (ZipInputStream tempIn = new ZipInputStream(new FileInputStream(aSourceFile));
             ZipOutputStream tempOut = new ZipOutputStream(new FileOutputStream(aDestinationFile));){
            tempOut.setLevel(9);
            ZipEntry tempEntry = tempIn.getNextEntry();
            while (tempEntry != null) {
                String tempName = tempEntry.getName();
                this.log.debug((CharSequence)("Entry=" + tempName));
                if (!tempEntry.isDirectory()) {
                    if (aReplacer.skipEntry(tempName)) {
                        this.log.debug((CharSequence)("Skip entry: " + tempName));
                    } else {
                        try {
                            InputStream tempEntryStream;
                            if (this.isReplaced(tempName)) {
                                String tempWithoutRepositoryPrefix = tempName.substring(tempName.indexOf("/") + 1);
                                this.log.debug((CharSequence)("Replace content: " + tempName));
                                File tempLocalFile = new File(this.getMavenLocalRepositoryFolder() + "/" + tempWithoutRepositoryPrefix);
                                tempEntryStream = aReplacer.replace(tempWithoutRepositoryPrefix, tempLocalFile, tempIn);
                            } else {
                                this.log.debug((CharSequence)("Not matching replace pattern. Keep content: " + tempName));
                                tempEntryStream = tempIn;
                            }
                            ZipEntry tempOutEntry = this.copyZipEntry(tempEntry);
                            tempOut.putNextEntry(tempOutEntry);
                            int tempRead = ((InputStream)tempEntryStream).read(tempBuff);
                            while (tempRead > 0) {
                                tempOut.write(tempBuff, 0, tempRead);
                                tempRead = ((InputStream)tempEntryStream).read(tempBuff);
                            }
                            tempOut.closeEntry();
                        }
                        catch (IOException | RuntimeException e) {
                            throw new RuntimeException("Error processing " + tempEntry, e);
                        }
                    }
                }
                tempEntry = tempIn.getNextEntry();
            }
        }
    }

    private ZipEntry copyZipEntry(ZipEntry anEntry) {
        FileTime tempLastModifiedTime;
        FileTime tempLastAccessTime;
        FileTime tempCreationTime;
        ZipEntry tempOutEntry = new ZipEntry(anEntry.getName());
        String tempComment = anEntry.getComment();
        if (tempComment != null) {
            tempOutEntry.setComment(tempComment);
        }
        if ((tempCreationTime = anEntry.getCreationTime()) != null) {
            tempOutEntry.setCreationTime(tempCreationTime);
        }
        if ((tempLastAccessTime = anEntry.getLastAccessTime()) != null) {
            tempOutEntry.setLastAccessTime(tempLastAccessTime);
        }
        if ((tempLastModifiedTime = anEntry.getLastModifiedTime()) != null) {
            tempOutEntry.setLastModifiedTime(tempLastModifiedTime);
        }
        tempOutEntry.setTime(anEntry.getTime());
        tempOutEntry.setExtra(anEntry.getExtra());
        tempOutEntry.setMethod(8);
        return tempOutEntry;
    }

    public String getMavenLocalRepositoryFolder() {
        return this.mavenLocalRepositoryFolder;
    }

    public void setMavenLocalRepositoryFolder(String aDependencyFolder) {
        this.mavenLocalRepositoryFolder = aDependencyFolder;
    }

    public static byte[] getReplacedBytes() {
        return REPLACED_BYTES;
    }
}

