/*
 * Decompiled with CFR 0.152.
 */
package io.github.c_a_services.mule4.jar;

import io.github.c_a_services.mule4.jar.impl.ZipCompressHelper;
import io.github.c_a_services.mule4.jar.impl.ZipContentReplacer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="jar-compress")
public class MulestacMavenJarCompressPlugin
extends AbstractMojo {
    @Parameter(property="sourceFile", required=true, defaultValue="${basedir}/target/${project.artifactId}-${project.version}-mule-application.jar")
    private File sourceFile;
    @Parameter(property="temporaryFile", required=true, defaultValue="${basedir}/target/${project.artifactId}-${project.version}-mule-application-temp.jar")
    private File temporaryFile;
    @Parameter(property="keepTemporaryFile", required=true, defaultValue="false")
    private boolean keepTemporaryFile;
    @Parameter(property="compress-jar-skip", required=false, defaultValue="false")
    private boolean skip;
    @Parameter
    private List<String> stripMatchingFiles;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;

    protected String getBasedir() {
        return this.localRepository.getBasedir();
    }

    public void execute() throws MojoExecutionException {
        Log tempLog = this.getLog();
        tempLog.info((CharSequence)("System Charset=" + Charset.defaultCharset()));
        tempLog.info((CharSequence)("sourceFile=" + this.getSourceFile()));
        tempLog.info((CharSequence)("destinationFile=" + this.getTemporaryFile()));
        tempLog.info((CharSequence)("keepTemporaryFile=" + this.isKeepTemporaryFile()));
        tempLog.info((CharSequence)("dependencyFolder=" + this.getBasedir()));
        tempLog.info((CharSequence)("stripFilesMatching=" + this.getStripMatchingFiles()));
        if (this.skip) {
            tempLog.warn((CharSequence)"Compress is skipped.");
        } else {
            tempLog.info((CharSequence)"compress...");
            try {
                this.doExecute();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error", (Exception)e);
            }
            tempLog.info((CharSequence)"compress finished...");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doExecute() throws IOException, MojoExecutionException {
        ZipCompressHelper tempZipCompressHelper = new ZipCompressHelper(this.getLog());
        tempZipCompressHelper.setMavenLocalRepositoryFolder(this.getBasedir());
        final byte[] tempReplacedBytes = tempZipCompressHelper.getReplacedBytes();
        ZipContentReplacer tempReplacer = new ZipContentReplacer(){

            @Override
            public InputStream replace(String aName, File aLocalFile, InputStream aIn) {
                if (aLocalFile.exists()) {
                    MulestacMavenJarCompressPlugin.this.getLog().info((CharSequence)("Replace content:" + aName));
                    return new ByteArrayInputStream(tempReplacedBytes);
                }
                MulestacMavenJarCompressPlugin.this.getLog().warn((CharSequence)("Keep content: " + aName + " as not existing: " + aLocalFile.getAbsolutePath()));
                return aIn;
            }

            @Override
            public boolean skipEntry(String aName) {
                List<String> tempStripMatchingFiles = MulestacMavenJarCompressPlugin.this.getStripMatchingFiles();
                if (tempStripMatchingFiles != null) {
                    for (String tempRegex : tempStripMatchingFiles) {
                        if (!aName.matches(tempRegex)) continue;
                        MulestacMavenJarCompressPlugin.this.getLog().info((CharSequence)("Remove entry " + aName + " as matching " + tempRegex));
                        return true;
                    }
                }
                return false;
            }
        };
        File tempSourceFile = this.getSourceFile();
        File tempDestinationFile = this.getTemporaryFile();
        tempZipCompressHelper.copyZip(tempSourceFile, tempDestinationFile, tempReplacer);
        this.getLog().info((CharSequence)(tempSourceFile.getName() + " Size=" + tempSourceFile.length()));
        this.getLog().info((CharSequence)(tempDestinationFile.getName() + " Size=" + tempDestinationFile.length()));
        if (this.isKeepTemporaryFile()) {
            FileUtils.copyFile((File)tempDestinationFile, (File)tempSourceFile);
            this.getLog().info((CharSequence)("Copied " + tempDestinationFile + " to " + tempSourceFile));
            return;
        } else {
            if (!tempSourceFile.delete()) throw new IOException("Could not delete " + tempSourceFile);
            if (!tempDestinationFile.renameTo(tempSourceFile)) throw new IOException("Could not rename " + tempDestinationFile + " to " + tempSourceFile);
            this.getLog().info((CharSequence)("Renamed " + tempDestinationFile + " to " + tempSourceFile));
        }
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File aSourceFile) {
        this.sourceFile = aSourceFile;
    }

    public File getTemporaryFile() {
        return this.temporaryFile;
    }

    public void setTemporaryFile(File aDestinationFile) {
        this.temporaryFile = aDestinationFile;
    }

    public boolean isKeepTemporaryFile() {
        return this.keepTemporaryFile;
    }

    public void setKeepTemporaryFile(boolean aKeepTemporaryFile) {
        this.keepTemporaryFile = aKeepTemporaryFile;
    }

    public List<String> getStripMatchingFiles() {
        return this.stripMatchingFiles;
    }

    public void setStripMatchingFiles(List<String> aStripFilesMatching) {
        this.stripMatchingFiles = aStripFilesMatching;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository aLocalRepository) {
        this.localRepository = aLocalRepository;
    }
}

