/*
 * Decompiled with CFR 0.152.
 */
package com.caij.easypermissions;

import android.content.DialogInterface;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.caij.easypermissions.PermissionDialog;
import com.caij.easypermissions.PermissionFragment;
import com.caij.easypermissions.PermissionListener;
import com.caij.easypermissions.Permissions;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 12\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u001bH&J\b\u0010\u001c\u001a\u00020\u001bH&J,\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120 H\u0004J\b\u0010\"\u001a\u00020\u001eH&J#\u0010#\u001a\u00020\u001b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010$\u001a\u00020%H&\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u0017H&J\b\u0010)\u001a\u00020\u001bH\u0016J\u0018\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,2\u0006\u0010(\u001a\u00020\u0017H&J\b\u0010-\u001a\u00020\u001bH\u0004J\b\u0010.\u001a\u00020\u001bH\u0002J\u000e\u0010/\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u0017J\b\u00100\u001a\u00020\u001bH&R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00062"}, d2={"Lcom/caij/easypermissions/BasePermissionManager;", "", "permissions", "Lcom/caij/easypermissions/Permissions;", "(Lcom/caij/easypermissions/Permissions;)V", "fragment", "Landroidx/fragment/app/Fragment;", "fragmentActivity", "Landroidx/fragment/app/FragmentActivity;", "getFragmentActivity", "()Landroidx/fragment/app/FragmentActivity;", "permissionDialog", "Lcom/caij/easypermissions/PermissionDialog;", "getPermissionDialog", "()Lcom/caij/easypermissions/PermissionDialog;", "permissionListener", "Lcom/caij/easypermissions/PermissionListener;", "", "", "getPermissions", "()[Ljava/lang/String;", "[Ljava/lang/String;", "showReasonType", "", "getShowReasonType", "()I", "afterRequestReasonDialogOkClick", "", "finish", "isAllGranted", "", "granted", "", "denied", "hasPermissions", "onRequestPermissionsResult", "grantResults", "", "([Ljava/lang/String;[I)V", "onSettingActivityResult", "requestCode", "request", "requestPermissionType", "permissionFragment", "Lcom/caij/easypermissions/PermissionFragment;", "showAfterRequestReasonDialog", "showBeforeRequestReasonDialog", "toFragmentRequest", "toRequest", "Companion", "easypermissions_release"})
public abstract class BasePermissionManager {
    private final PermissionListener permissionListener;
    private Fragment fragment;
    @NotNull
    private final String[] permissions;
    private final int showReasonType;
    @NotNull
    private final FragmentActivity fragmentActivity;
    @NotNull
    private final PermissionDialog permissionDialog;
    @NotNull
    public static final String FRAGMENT_TAG = "permission_fragment_tag";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final String[] getPermissions() {
        return this.permissions;
    }

    protected final int getShowReasonType() {
        return this.showReasonType;
    }

    @NotNull
    protected final FragmentActivity getFragmentActivity() {
        return this.fragmentActivity;
    }

    @NotNull
    protected final PermissionDialog getPermissionDialog() {
        return this.permissionDialog;
    }

    private final void showBeforeRequestReasonDialog() {
        this.permissionDialog.showReason(this.fragmentActivity, this.permissions, new DialogInterface.OnClickListener(this){
            final /* synthetic */ BasePermissionManager this$0;

            public final void onClick(DialogInterface $noName_0, int $noName_1) {
                this.this$0.toRequest();
            }
            {
                this.this$0 = basePermissionManager;
            }
        }, new DialogInterface.OnClickListener(this){
            final /* synthetic */ BasePermissionManager this$0;

            public final void onClick(DialogInterface $noName_0, int $noName_1) {
                this.this$0.finish();
            }
            {
                this.this$0 = basePermissionManager;
            }
        });
    }

    public void request() {
        if (this.hasPermissions()) {
            this.finish();
        } else {
            switch (this.showReasonType) {
                case 2: {
                    this.showBeforeRequestReasonDialog();
                    break;
                }
                case 1: {
                    this.toRequest();
                    break;
                }
                default: {
                    this.toRequest();
                }
            }
        }
    }

    public final void toFragmentRequest(int requestCode) {
        FragmentManager fragmentManager = this.fragmentActivity.getSupportFragmentManager();
        this.fragment = fragmentManager.findFragmentByTag(FRAGMENT_TAG);
        if (this.fragment instanceof PermissionFragment) {
            Fragment fragment = this.fragment;
            if (fragment == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.caij.easypermissions.PermissionFragment");
            }
            PermissionFragment permissionFragment = (PermissionFragment)fragment;
            permissionFragment.setArguments(PermissionFragment.newArgs(this.permissions, requestCode));
            permissionFragment.setPermissionManager(this);
            this.requestPermissionType(permissionFragment, requestCode);
        } else {
            PermissionFragment permissionFragment = PermissionFragment.newInstance(this.permissions, requestCode);
            permissionFragment.setPermissionManager(this);
            fragmentManager.beginTransaction().add((Fragment)permissionFragment, FRAGMENT_TAG).commitAllowingStateLoss();
        }
    }

    protected final void showAfterRequestReasonDialog() {
        this.permissionDialog.showReason(this.fragmentActivity, this.permissions, new DialogInterface.OnClickListener(this){
            final /* synthetic */ BasePermissionManager this$0;

            public final void onClick(DialogInterface $noName_0, int $noName_1) {
                this.this$0.afterRequestReasonDialogOkClick();
            }
            {
                this.this$0 = basePermissionManager;
            }
        }, new DialogInterface.OnClickListener(this){
            final /* synthetic */ BasePermissionManager this$0;

            public final void onClick(DialogInterface $noName_0, int $noName_1) {
                this.this$0.finish();
            }
            {
                this.this$0 = basePermissionManager;
            }
        });
    }

    protected final void finish(boolean isAllGranted, @NotNull List<String> granted, @NotNull List<String> denied) {
        Intrinsics.checkNotNullParameter(granted, (String)"granted");
        Intrinsics.checkNotNullParameter(denied, (String)"denied");
        this.permissionListener.onRequestPermissionsResult(isAllGranted, granted, denied);
        if (this.fragment != null) {
            FragmentTransaction fragmentTransaction = this.fragmentActivity.getSupportFragmentManager().beginTransaction();
            Fragment fragment = this.fragment;
            Intrinsics.checkNotNull((Object)fragment);
            fragmentTransaction.remove(fragment).commitAllowingStateLoss();
        }
    }

    public abstract void onSettingActivityResult(int var1);

    public abstract void requestPermissionType(@NotNull PermissionFragment var1, int var2);

    public abstract void finish();

    public abstract void toRequest();

    public abstract void afterRequestReasonDialogOkClick();

    public abstract void onRequestPermissionsResult(@NotNull String[] var1, @NotNull int[] var2);

    public abstract boolean hasPermissions();

    public BasePermissionManager(@NotNull Permissions permissions) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        PermissionListener permissionListener = permissions.permissionListener;
        Intrinsics.checkNotNullExpressionValue((Object)permissionListener, (String)"permissions.permissionListener");
        this.permissionListener = permissionListener;
        Intrinsics.checkNotNullExpressionValue((Object)permissions.permissions, (String)"permissions.permissions");
        this.permissions = permissions.permissions;
        this.showReasonType = permissions.showReasonType;
        FragmentActivity fragmentActivity = permissions.fragmentActivity;
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"permissions.fragmentActivity");
        this.fragmentActivity = fragmentActivity;
        PermissionDialog permissionDialog = permissions.permissionDialog;
        Intrinsics.checkNotNullExpressionValue((Object)permissionDialog, (String)"permissions.permissionDialog");
        this.permissionDialog = permissionDialog;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/caij/easypermissions/BasePermissionManager$Companion;", "", "()V", "FRAGMENT_TAG", "", "easypermissions_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

