/*
 * Decompiled with CFR 0.152.
 */
package com.caij.easypermissions;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentActivity;
import com.caij.easypermissions.PermissionDialog;
import com.caij.easypermissions.PermissionMapKt;
import com.caij.easypermissions.R;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J3\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J3\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/caij/easypermissions/DefaultPermissionDialog;", "Lcom/caij/easypermissions/PermissionDialog;", "()V", "createContentView", "Landroid/view/View;", "fragmentActivity", "Landroidx/fragment/app/FragmentActivity;", "permissions", "", "", "(Landroidx/fragment/app/FragmentActivity;[Ljava/lang/String;)Landroid/view/View;", "getAccentColor", "", "activity", "Landroid/app/Activity;", "showReason", "", "okClickListener", "Landroid/content/DialogInterface$OnClickListener;", "cancelClickListener", "(Landroidx/fragment/app/FragmentActivity;[Ljava/lang/String;Landroid/content/DialogInterface$OnClickListener;Landroid/content/DialogInterface$OnClickListener;)V", "showSetting", "easypermissions_release"})
public final class DefaultPermissionDialog
implements PermissionDialog {
    @Override
    public void showReason(@NotNull FragmentActivity fragmentActivity, @NotNull String[] permissions, @NotNull DialogInterface.OnClickListener okClickListener, @NotNull DialogInterface.OnClickListener cancelClickListener) {
        TextView tvMessage;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"fragmentActivity");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)okClickListener, (String)"okClickListener");
        Intrinsics.checkNotNullParameter((Object)cancelClickListener, (String)"cancelClickListener");
        View contentView = this.createContentView(fragmentActivity, permissions);
        TextView textView = tvMessage = (TextView)contentView.findViewById(R.id.messageText);
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"tvMessage");
        textView.setText((CharSequence)"\u8be5\u529f\u80fd\u9700\u8981\u8fd9\u4e9b\u6743\u9650\u624d\u80fd\u7ee7\u7eed\u4f7f\u7528\u3002");
        AlertDialog dialog = new AlertDialog.Builder((Context)fragmentActivity).setView(contentView).setPositiveButton((CharSequence)"\u5141\u8bb8", okClickListener).setNegativeButton((CharSequence)"\u62d2\u7edd", cancelClickListener).create();
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
    }

    @Override
    public void showSetting(@NotNull FragmentActivity fragmentActivity, @NotNull String[] permissions, @NotNull DialogInterface.OnClickListener okClickListener, @NotNull DialogInterface.OnClickListener cancelClickListener) {
        TextView tvMessage;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"fragmentActivity");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)okClickListener, (String)"okClickListener");
        Intrinsics.checkNotNullParameter((Object)cancelClickListener, (String)"cancelClickListener");
        View contentView = this.createContentView(fragmentActivity, permissions);
        TextView textView = tvMessage = (TextView)contentView.findViewById(R.id.messageText);
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"tvMessage");
        textView.setText((CharSequence)"\u4f60\u8bf7\u6c42\u7684\u6743\u9650\u5df2\u88ab\u62d2\u7edd\u5e76\u4e0d\u518d\u63d0\u793a\uff0c\u8bf7\u5230\u8bbe\u7f6e\u4e2d\u624b\u52a8\u5f00\u542f\u3002");
        AlertDialog dialog = new AlertDialog.Builder((Context)fragmentActivity).setView(contentView).setPositiveButton((CharSequence)"\u53bb\u8bbe\u7f6e", okClickListener).setNegativeButton((CharSequence)"\u62d2\u7edd", cancelClickListener).create();
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
    }

    private final View createContentView(FragmentActivity fragmentActivity, String[] permissions) {
        PackageManager packageManager = fragmentActivity.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"fragmentActivity.packageManager");
        PackageManager pm = packageManager;
        View contentView = LayoutInflater.from((Context)((Context)fragmentActivity)).inflate(R.layout.permission_default_dialog_layout, null);
        LinearLayout linearLayout = (LinearLayout)contentView.findViewById(R.id.permissionsLayout);
        int accentColor = this.getAccentColor((Activity)fragmentActivity);
        HashSet<String> tempSet = new HashSet<String>();
        for (String permission : permissions) {
            View view = LayoutInflater.from((Context)((Context)fragmentActivity)).inflate(R.layout.permission_item, (ViewGroup)linearLayout, false);
            ImageView imageView = (ImageView)view.findViewById(R.id.permissionIcon);
            TextView textView = (TextView)view.findViewById(R.id.permissionText);
            try {
                PermissionGroupInfo groupInfo;
                String permissionGroup = null;
                if (Build.VERSION.SDK_INT == 29) {
                    permissionGroup = PermissionMapKt.getPermissionMapOnQ().get(permission);
                } else if (Build.VERSION.SDK_INT == 30) {
                    permissionGroup = PermissionMapKt.getPermissionMapOnR().get(permission);
                } else if (Build.VERSION.SDK_INT == 31) {
                    permissionGroup = PermissionMapKt.getPermissionMapOnS().get(permission);
                } else if (Build.VERSION.SDK_INT > 29) {
                    permissionGroup = PermissionMapKt.getPermissionMapOnS().get(permission);
                } else {
                    PermissionInfo permissionInfo;
                    Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity.getPackageManager().getPermissionInfo(permission, 0), (String)"fragmentActivity.package\u2026issionInfo(permission, 0)");
                    permissionGroup = permissionInfo.group;
                }
                String string2 = permissionGroup;
                Intrinsics.checkNotNull((Object)string2);
                Intrinsics.checkNotNullExpressionValue((Object)pm.getPermissionGroupInfo(string2, 0), (String)"pm.getPermissionGroupInfo(permissionGroup!!, 0)");
                if (tempSet.contains(permissionGroup)) continue;
                if (Intrinsics.areEqual((Object)"android.permission.MANAGE_EXTERNAL_STORAGE", (Object)permission)) {
                    textView.setText(R.string.manage_external_storage);
                } else {
                    TextView textView2 = textView;
                    Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"textView");
                    textView2.setText(fragmentActivity.getText(groupInfo.labelRes));
                }
                imageView.setImageResource(groupInfo.icon);
                if (accentColor != -1) {
                    ImageView imageView2 = imageView;
                    Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"imageView");
                    imageView2.setImageTintList(ColorStateList.valueOf((int)accentColor));
                }
                tempSet.add(permissionGroup);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            linearLayout.addView(view);
        }
        View view = contentView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"contentView");
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getAccentColor(Activity activity) {
        int[] tmpArray = new int[]{R.attr.colorAccent};
        TypedArray typedArray = activity.obtainStyledAttributes(null, tmpArray);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"activity.obtainStyledAttributes(null, tmpArray)");
        TypedArray a = typedArray;
        try {
            int n = a.getColor(0, -1);
            return n;
        }
        finally {
            a.recycle();
        }
    }
}

